<?php

namespace SocialFeedsPro\Settings;

if(!defined('ABSPATH')){
	exit;
}

class UI{

	static function instagram_connect_screen(){
		$feed_type = isset($_GET['type']) ? sanitize_text_field(wp_unslash($_GET['type'])) : '';

		if(empty($feed_type)){
			$feed_type = 'username';
		}

		$preview_url = isset($_GET['preview_url']) ? esc_url_raw( wp_unslash( $_GET['preview_url'] ) ) : '';
		$message = isset($_GET['socialfeeds_msg']) ? sanitize_text_field( wp_unslash( $_GET['socialfeeds_msg'] ) ) : '';
		$opts = get_option('socialfeeds_instagram_option', []);
		
		// Editing existing feed
		$edit_id = isset($_GET['edit_id']) ? sanitize_text_field(wp_unslash($_GET['edit_id'])) : '';
		$feed_settings = [];
		$socialfeeds_input_value = '';
		$selected_account_index = null;

		if ($edit_id && !empty($opts['instagram_feeds'])) {
			foreach ($opts['instagram_feeds'] as $feed) {
				if (isset($feed['id']) && (string) $feed['id'] === (string) $edit_id) {
					if (isset($feed['account_id'])) {
					$connected_accounts = isset($opts['instagram_connected_accounts']) ? $opts['instagram_connected_accounts'] : [];
						foreach ($connected_accounts as $idx => $account) {
							if (isset($account['id']) && (string) $account['id'] === (string) $feed['account_id']) {
							$selected_account_index = $idx;
							break;
							}
						}
					}
					break;
				}
			}
		}

		if (!empty($edit_id)) {
			$feeds = isset($opts['instagram_feeds']) ? $opts['instagram_feeds'] : [];
			foreach ($feeds as $f) {
				if (isset($f['id']) && (string) $f['id'] === (string) $edit_id) {
					if (!empty($f['type'])) {
						$feed_type = $f['type'];
					}
					if (isset($f['input'])) {
						$socialfeeds_input_value = rawurlencode($f['input']);
					}
					if (isset($f['preview']) && !$preview_url) {
						$preview_url = $f['preview'];
					}
					if (isset($f['settings']) && is_array($f['settings'])) {
						$feed_settings = $f['settings'];
					}
					break;
				}
			}
		}
		
		// Defaults
		$defaults = [
			// Layout
			'instagram_layout' => 'grid', // grid, carousel, masonry, highlight
			'instagram_aspect_ratio' => '',	 // px, optional
			'instagram_padding' => 8,
			'instagram_number_posts_desktop' => 12,
			'instagram_number_posts_mobile' => 6,
			'instagram_columns_desktop' => 3,
			'instagram_columns_tablet' => 2,
			'instagram_columns_mobile' => 1,
			// Color scheme
			'instagram_color_scheme' => 'light',
			'instagram_custom_color' => '#000000',
			// Header
			'instagram_header_enabled' => 1,
			'instagram_header_size' => 56,	// px
			'instagram_use_custom_avatar' => 0,
			'instagram_custom_avatar' => '', // URL
			'instagram_show_bio_text' => 1,
			'instagram_show_followers' => 0,
			'instagram_media_count' => 0,
			'instagram_header_style' => 'left', // standard, boxed, centered, left, middle, right
			// Stories
			'instagram_include_stories' => 0,
			'instagram_story_duration' => 5, // seconds
			// Media options
			'instagram_caption_enabled' => 1,
			'instagram_likes' => 0,
			'instagram_comments' => 0,
			'instagram_video_views' => 0,
			'instagram_hover_state' => 'overlay', // overlay, scale, none
			// Load more & follow
			'instagram_load_more_enabled' => 1,
			'instagram_load_more_text' => 'Load More',
			'instagram_load_more_bg_color' => '#350ae1',
			'instagram_load_more_text_color' => '#FFFFFF',
			'instagram_load_more_hover_color' => '#160755',
			'instagram_infinite_scroll' => 0,
			'instagram_follow_button_enabled' => 1,
			'instagram_follow_button_text' => 'Follow on Instagram',
			'instagram_follow_button_bg_color' => '#FF3B30',
			'instagram_follow_button_text_color' => '#ffffff',
			'instagram_follow_button_hover_color' => '#740c06',
			// Lightbox
			'instagram_lightbox_enabled' => 1,
			// Source / API
			'instagram_source_type' => 'business', // personal, business, manual
			'instagram_account_id' => '',
			'instagram_access_token' => '',
			// Filters / moderation
			'instagram_filter_include_words' => '',
			'instagram_filter_exclude_words' => '',
			'instagram_show_photos' => 1,
			'instagram_show_feed_posts' => 1,
			'instagram_show_igtv' => 0,
			'instagram_show_reels' => 1,
			'instagram_post_offset' => 0,
			'instagram_sort_by' => 'newest', // newest, likes, random
			// Shoppable
			'instagram_shoppable_enabled' => 0,
			// Advanced
			'instagram_max_concurrent_requests' => 2,
			'instagram_custom_template_enabled' => 0,
			'instagram_custom_template_path' => '',
		];
		
		$settings = array_merge($defaults, $feed_settings);
		$admin_post = esc_url(admin_url('admin-ajax.php'));
		$admin_page = admin_url('admin.php?page=socialfeeds&tab=templates');
		
		echo '<div class="socialfeeds-wizard-container">';
		
		$connection_type = isset($_GET['connection_type']) ? sanitize_text_field(wp_unslash($_GET['connection_type'])) : '';
		
		if (!empty($connection_type) && empty($feed_type)) {
			self::render_instagram_feed_type_selection($connection_type, $opts);
		} else {
			self::render_instagram_wizard_form($feed_type, $preview_url, $edit_id, $settings, $opts, $admin_post, $selected_account_index);
			self::render_instagram_embed_modal();
		}
		
		echo '</div>';
	}

	static function render_instagram_feed_type_selection($connection_type, $opts) {
		if($connection_type === 'manual' && isset($_GET['step']) && 'token' === $_GET['step']){
			echo '<div class="socialfeeds-feed-main-card">
					<div class="socialfeeds-feed-main-header">
						<h2>'.esc_html__('Enter Access Token', 'socialfeeds-pro') . '</h2>
						<p>'.esc_html__('Paste a long-lived Instagram Graph API token to connect your account.', 'socialfeeds-pro').'</p>
					</div>
					<div class="socialfeeds-standalone-wrapper">
						<textarea id="socialfeeds-standalone-token-input" class="socialfeeds-standalone-token-input"
							placeholder="Paste long-lived access token here" style="width:100%; min-height:100px; margin-bottom:15px; padding:12px; border-radius:8px; border:1px solid #e2e8f0;"></textarea>
						<p id="socialfeeds-standalone-token-message" class="socialfeeds-standalone-token-message"></p>
						<div class="socialfeeds-modal-actions" style="flex-direction:row; justify-content:flex-end; gap:20px; margin-top:40px; border-top:1px solid #f1f5f9; padding-top:20px;">
							<a href="'.esc_url(admin_url('admin.php?page=socialfeeds&connection_type=manual#instagram')).'" class="socialfeeds-btn-manage" style="width:auto; padding:10px 30px; border:none;"> ' . esc_html__('Back', 'socialfeeds-pro') . '</a>
							<button id="socialfeeds-ig-validate-btn" class="socialfeeds-btn-sync" style="padding:10px 40px;">
								' . esc_html__('Validate & Connect', 'socialfeeds-pro') . '
							</button>
						</div>
					</div>
				</div>';
		} else {
			echo '<div class="socialfeeds-feed-main-card">
					<div class="socialfeeds-feed-main-header">
						<h2>'.esc_html__('Select Feed Type', 'socialfeeds-pro').'</h2>
						<p>'.esc_html__('Choose the Instagram source type for this feed.', 'socialfeeds-pro').'</p>
					</div>
					
					<div class="socialfeeds-feed-type-v2">
						<!-- User Timeline -->
						<div class="socialfeeds-type-card selected" data-type="username">
							<div class="socialfeeds-p-card-icon instagram" style="background:#fdf2f8; color:#db2777; margin-bottom:15px;">
								<span class="dashicons dashicons-instagram"></span>
							</div>
							<h3>'.esc_html__('User Timeline', 'socialfeeds-pro').'</h3>
							<p>'.esc_html__('Fetch posts from your Instagram profile.', 'socialfeeds-pro').'</p>
						</div>

						<!-- Hashtag -->
						<div class="socialfeeds-type-card" data-type="hashtag">
							<div class="socialfeeds-p-card-icon" style="background:#fefce8; color:#ca8a04; margin-bottom:15px;">
								<span class="dashicons dashicons-hash"></span>
							</div>
							<h3>'.esc_html__('Public Hashtag', 'socialfeeds-pro') . '</h3>
							<p>'.esc_html__('Fetch posts from a public Instagram hashtag.', 'socialfeeds-pro').'</p>
						</div>

						<!-- Tagged -->
						<div class="socialfeeds-type-card" data-type="manual">
							<div class="socialfeeds-p-card-icon" style="background:#f0fdf4; color:#16a34a; margin-bottom:15px;">
								<span class="dashicons dashicons-admin-users"></span>
							</div>
							<h3>'.esc_html__('Tagged Posts', 'socialfeeds-pro').'</h3>
							<p>'.esc_html__('Display posts your Instagram account has been tagged in.', 'socialfeeds-pro').'</p>
						</div>

						<!-- Social Wall -->
						<div class="socialfeeds-type-card" data-type="social-wall">
							<div class="socialfeeds-p-card-icon" style="background:#f1f5f9; color:#475569; margin-bottom:15px;">
								<span class="dashicons dashicons-layout"></span>
							</div>
							<h3>'.esc_html__('Social Wall', 'socialfeeds-pro').'</h3>
							<p>'.esc_html__('Combine sources from multiple social media platforms.', 'socialfeeds-pro').'</p>
						</div>
					</div>

					<div class="socialfeeds-modal-actions" style="flex-direction:row; justify-content:flex-end; gap:20px; margin-top:40px; border-top:1px solid #f1f5f9; padding-top:20px;">
						<a href="'.esc_url(admin_url('admin.php?page=socialfeeds#instagram')) . '" class="socialfeeds-btn-manage" style="width:auto; padding:10px 30px; border:none;">'.esc_html__('Cancel', 'socialfeeds-pro').'</a>
						<a id="socialfeeds-select-type-btn-instagram" class="socialfeeds-btn-sync socialfeeds-disabled" href="#" style="padding:10px 40px;">'.esc_html__('Next', 'socialfeeds-pro').' <span class="dashicons dashicons-arrow-right-alt2" style="margin-top:2px;"></span></a>
					</div>
					<input type="hidden" id="socialfeeds-connection-type-hidden" value="' . esc_attr($connection_type) . '">
				</div>';
		}
	}
	
	static function render_instagram_wizard_form($feed_type, $preview_url, $edit_id, $settings, $opts, $admin_post, $selected_account_index = null) {
		echo '<form method="post" action="' . esc_attr($admin_post) . '" id="socialfeeds-instagram-wizard-form" class="socialfeeds-wizard-form">';
			wp_nonce_field('socialfeeds_pro_nonce', 'nonce');
			echo '<input type="hidden" name="action" value="socialfeeds_pro_instagram_wizard_save">
			<input type="hidden" id="socialfeeds_stage" name="stage" value="">
			<input type="hidden" name="feed_type" value="' . esc_attr($feed_type) . '">
			<input type="hidden" id="preview_url_hidden" name="preview_url" value="' . esc_attr($preview_url) . '">
			<div class="socialfeeds-wizard-tabs">
				<div class="socialfeeds-wizard-tab active" id="socialfeeds-instagram-tab-source" data-tab="source">
					<span class="socialfeeds-tab-number">1</span>
					<span class="socialfeeds-tab-label">' . esc_html__('Source', 'socialfeeds-pro') . '</span>
				</div>
				<div class="socialfeeds-wizard-tab" id="socialfeeds-instagram-tab-customize" data-tab="customize">
					<span class="socialfeeds-tab-number">2</span>
					<span class="socialfeeds-tab-label">' . esc_html__('Customize', 'socialfeeds-pro') . '</span>
				</div>
			</div>
			<div class="socialfeeds-wizard-tab-content-wrapper">';
		
		// TAB 1: SOURCE INPUT
		echo '<div class="socialfeeds-wizard-tab-content active" id="socialfeeds-instagram-content-source">';
		self::render_instagram_source_tab($feed_type, $edit_id, $opts, $selected_account_index);	
		echo '</div>';
		
		// TAB 2: CUSTOMIZE & SETTINGS
		echo '<div class="socialfeeds-wizard-tab-content" id="socialfeeds-instagram-content-customize">';
			self::render_instagram_customize_tab($settings, $preview_url, $edit_id, $opts);
		echo '</div>';
		
		echo '</div></form>';
	}

	static function render_instagram_source_tab($feed_type, $edit_id, $opts, $selected_account_index = null){
		echo '<div class="socialfeeds-source-card-v2">
				<div class="socialfeeds-feed-main-header" style="margin-bottom:30px;">
					<h2>'.esc_html__('Add Source', 'socialfeeds-pro').'</h2>
					<p>'.esc_html__('Connect your Instagram account or other sources to fetch posts.', 'socialfeeds-pro').'</p>
				</div>';
		
		if ($feed_type === 'username') {
			echo '<div class="socialfeeds-wizard-step active" id="socialfeeds-step-1">
				<div class="socialfeeds-accounts-list" id="socialfeeds-accounts-list" style="display: grid; gap: 12px; margin-bottom: 20px;">';
			
			$connected_accounts = isset($opts['instagram_connected_accounts']) ? $opts['instagram_connected_accounts'] : [];
			if (empty($connected_accounts)) {
				echo '<div style="padding:40px; text-align:center; background:#f8fafc; border-radius:12px; border:2px dashed #e2e8f0;">
						<p style="color:#64748b; margin-bottom:15px;">' . esc_html__('No connected accounts yet. Add one below.', 'socialfeeds-pro') . '</p>
					  </div>';
			} else {
				foreach ($connected_accounts as $idx => $account) {
			$checked = '';
			if ($edit_id && $selected_account_index !== null) {
				$checked = ($idx === $selected_account_index) ? ' checked' : '';
			} else {
				$checked = ($idx === 0) ? ' checked' : '';
			}
					echo '<label class="socialfeeds-account-item ' . ($checked ? 'selected' : '') . '" style="display:flex; align-items:center; padding:15px; border:2px solid #e2e8f0; border-radius:12px; cursor:pointer; transition:all 0.2s;">
						<input type="radio" name="instagram_selected_account" id="socialfeeds-instagram-selected-account-'. esc_attr($idx) .'" value="' . esc_attr($idx) . '" style="margin-right:15px;" ' . esc_attr($checked) . '>
						<div style="width:48px; height:48px; border-radius:50%; overflow:hidden; background:#f1f5f9; margin-right:15px; display:flex; align-items:center; justify-content:center;">';
							if (!empty($account['profile_picture_url'])) {
								echo '<img src="' . esc_url($account['profile_picture_url']) . '" style="width:100%; height:100%; object-fit:cover;">';
							} else {
								echo '<span style="font-weight:600; color:#64748b;">' . esc_html(strtoupper(substr($account['username'], 0, 1))) . '</span>';
							}
						echo '</div>
						<div style="flex:1;">
							<strong style="display:block; font-size:15px; color:#1e293b;">' . esc_html($account['username']) . '</strong>
							<small style="color:#64748b;">' . esc_html(isset($account['account_type']) ? $account['account_type'] : 'PERSONAL') . ' Account</small>
						</div>
					</label>';
				}
			}
			
			echo '</div>
				<div style="margin-top:20px;">
					<button type="button" id="socialfeeds-wizard-add-account-btn" class="socialfeeds-btn-manage" style="width:100%; justify-content:center; border-style:dashed; background:#fff;">
						<span class="dashicons dashicons-plus" style="margin-top:2px;"></span> ' . esc_html__('Add New Account via Token', 'socialfeeds-pro') . '
					</button>
				</div>

				<div id="socialfeeds-wizard-token-form" style="display:none; margin-top:20px; padding:20px; background:#f8fafc; border-radius:12px; border:1px solid #e2e8f0;">
					<h4 style="margin:0 0 10px 0;">' . esc_html__('Enter Instagram Token', 'socialfeeds-pro') . '</h4>
					<textarea id="socialfeeds-wizard-token-input" placeholder="' . esc_html__('Paste your Instagram access token here...', 'socialfeeds-pro') . '" style="width:100%; min-height:80px; padding:12px; border-radius:8px; border:1px solid #e2e8f0; margin-bottom:12px;"></textarea>
					<div id="socialfeeds-wizard-token-message"></div>
					<div style="display:flex; gap:10px; justify-content:flex-end;">
						<button type="button" id="socialfeeds-wizard-cancel-token-btn" class="socialfeeds-btn-manage" style="border:none;">' . esc_html__('Cancel', 'socialfeeds-pro') . '</button>
						<button type="button" id="socialfeeds-wizard-validate-token-btn" class="socialfeeds-btn-sync">' . esc_html__('Validate & Connect', 'socialfeeds-pro') . '</button>
					</div>
				</div>

				<input type="hidden" id="socialfeeds-source-input-field" name="source_input" value="">
				<input type="hidden" name="instagram_source_type" value="username">
			</div>';
		}
		
		if(!empty($edit_id)){
			echo '<input type="hidden" name="edit_id" value="' . esc_attr($edit_id) . '">';
		}
		
		echo '<div class="socialfeeds-modal-actions" style="flex-direction:row; justify-content:flex-end; gap:20px; margin-top:40px; border-top:1px solid #f1f5f9; padding-top:20px;">
				<a href="' . esc_url(admin_url('admin.php?page=socialfeeds&action=create#instagram')) . '" class="socialfeeds-btn-manage" style="width:auto; padding:10px 30px; border:none;">' . esc_html__('Back', 'socialfeeds-pro') . '</a>
				<button type="button" class="socialfeeds-btn-sync" id="socialfeeds-ig-next-btn" style="padding:10px 40px;">' . esc_html__('Next Step', 'socialfeeds-pro') . ' <span class="dashicons dashicons-arrow-right-alt2" style="margin-top:2px;"></span></button>
			</div>
		</div>';
	}

	static function render_instagram_customize_tab($settings, $preview_url, $edit_id, $opts = []) {

		// Top Header Section (Title + Shortcode Controls)
		$platform_key = 'instagram';
		$shortcode_tag = $platform_key . '-feed';
		if($edit_id){
			$display_id = $edit_id;
		} else {
			$feeds = isset($opts['instagram_feeds']) ? $opts['instagram_feeds'] : [];
			$existing_ids = [];
			foreach ($feeds as $f) {
				if (isset($f['id'])) {
					$existing_ids[] = (string)$f['id'];
				}
			}
			$next_id = 1;
			while(in_array((string)$next_id, $existing_ids)){
				$next_id++;
			}
			$display_id = $next_id;
		}
		
		echo '<div class="socialfeeds-customize-header" style="display: flex; justify-content: space-between; align-items: flex-start; margin-bottom: 25px;">
			<div class="socialfeeds-customize-header-left">
				<h2 class="socialfeeds-title" style="margin: 0; font-size: 18px; font-weight: 700; color: #1e293b;">' . esc_html__('Customize Display', 'socialfeeds-pro') . '</h2>
				<p class="socialfeeds-desc" style="margin: 8px 0 0; color: #64748b; font-size: 13px;">' . esc_html__('Configure how your Instagram feed appears on your site.', 'socialfeeds-pro') . '</p>
			</div>
			<div class="socialfeeds-customize-header-right" style="display: flex; align-items: center; gap: 12px; background: #f8fafc; border: 1px solid #e2e8f0; padding: 5px 10px; border-radius: 12px;">
				<div style="margin-right: 15px;">
					<code id="socialfeeds-top-shortcode" style="background: transparent; border: none; font-size: 14px; color: #475569; padding: 0; font-family: monospace; letter-spacing: 0.5px;">'.esc_html('[socialfeeds id="'.$display_id.'" platform="instagram"]').'</code>
				</div>
				<button type="button" class="socialfeeds-copy-shortcode" data-shortcode="' . esc_attr('[socialfeeds id="'.$display_id.'" platform="instagram"]') . '" style="display: flex; align-items: center; gap: 6px; background: #fff; border: 1px solid #d1d5db; border-radius: 8px; padding: 8px 16px; cursor: pointer; color: #374151; font-weight: 500; font-size: 14px; box-shadow: 0 1px 2px rgba(0,0,0,0.05); transition: all 0.2s;">
					<span class="dashicons dashicons-admin-page" style="font-size: 18px; width: 18px; height: 18px; color: #64748b;"></span>
					' . esc_html__('Copy', 'socialfeeds-pro') . '
				</button>
				<button type="button" class="socialfeeds-fullscreen-btn" title="' . esc_attr__('Fullscreen', 'socialfeeds-pro') . '" style="display: flex; align-items: center; justify-content: center; background: #fff; border: 1px solid #d1d5db; border-radius: 8px; padding: 8px; cursor: pointer; width: 38px; height: 38px; color: #374151; box-shadow: 0 1px 2px rgba(0,0,0,0.05); transition: all 0.2s;">
					<span class="socialfeed-fullscreen dashicons dashicons-fullscreen-alt" style="font-size: 20px; width: 20px; height: 20px; color: #64748b;"></span>
				</button>
			</div>
		</div>';
		
		echo '<div class="socialfeeds-customize-columns">
			<div class="socialfeeds-customize-preview-column">
				<div class="socialfeeds-button-group justify-content-left" style="margin-bottom: 15px; margin-top: 0;">
					<a href="'.esc_url(admin_url('admin.php?page=socialfeeds#feeds')).'" class="button button-primary">'.esc_html__('All Feeds', 'socialfeeds-pro').'</a>
					<div class="socialfeeds-spacer"></div>
					<button type="submit" class="button button-primary" id="socialfeeds-save-btn">'.($edit_id ? esc_html__('Save', 'socialfeeds-pro') : esc_html__('Save', 'socialfeeds-pro')).'</button>
				</div>

				<div class="socialfeeds-customize-preview">
					<div class="socialfeeds-preview-header-bar">
						<span class="socialfeeds-preview-label">'.esc_html__('LIVE PREVIEW', 'socialfeeds-pro').'</span>
						<div class="socialfeeds-preview-device-toggles">
							<button type="button" class="socialfeeds-preview-device-btn active" data-width="100%" title="Desktop"><span class="dashicons dashicons-desktop"></span></button>
							<button type="button" class="socialfeeds-preview-device-btn" data-width="768" title="Tablet"><span class="dashicons dashicons-tablet"></span></button>
							<button type="button" class="socialfeeds-preview-device-btn" data-width="375" title="Mobile"><span class="dashicons dashicons-smartphone"></span></button>
						</div>
					</div>
					
					<div class="socialfeeds-preview-box-wrapper">
						<div class="socialfeeds-wizard-loader-overlay">
							<div class="socialfeeds-loader"></div>
						</div>
						<div class="socialfeeds-instagram-feed">
							<div id="socialfeeds-instagram-preview-header"></div>
							<div class="socialfeeds-preview-box" id="socialfeeds-instagram-preview-grid">
								<div class="socialfeeds-fetch-status-container" style="text-align:center; padding:10px; font-weight:500; color:#666;">
									<span id="socialfeeds-fetch-status"></span>
								</div>
							</div>
						</div>';
					
					echo '			
					</div>
					<div class="socialfeeds-load-more-wrap">
					</div>
				</div>
			</div>

			<div class="socialfeeds-customize-settings-sidebar">
				<div class="socialfeeds-sidebar-tabs">
					<button type="button" class="socialfeeds-sidebar-tab-btn active" data-target="socialfeeds-tab-general">'.esc_html__('General', 'socialfeeds-pro').'</button>
					<button type="button" class="socialfeeds-sidebar-tab-btn" data-target="socialfeeds-tab-style">'.esc_html__('Style', 'socialfeeds-pro').'</button>
				</div>

				<div class="socialfeeds-sidebar-content">';
					self::render_instagram_sidebar_general($settings);
					self::render_instagram_sidebar_style($settings);
		echo '	</div> <!-- End Sidebar Content -->
			</div> <!-- End Sidebar -->

		</div>';
	}

	static function render_instagram_sidebar_general($settings){

		echo '<div id="socialfeeds-tab-general" class="socialfeeds-sidebar-tab-pane active">
			<div class="socialfeeds-sidebar-header">
				<h3><span class="dashicons dashicons-admin-settings"></span>'.esc_html__('General', 'socialfeeds-pro').'</h3>
			</div>

			<!-- Layout Accordion -->
			<div class="socialfeeds-accordion-wrapper">
			<div class="socialfeeds-accordion-item">
				<div class="socialfeeds-accordion-header">
					<div class="socialfeeds-header-left">
						<div class="socialfeeds-icon-wrap" style="background: #eef2ff; color: #6366f1;">
							<span class="dashicons dashicons-layout"></span>
						</div>
						<div class="socialfeeds-title-wrap">
							<span class="socialfeeds-sidebar-title">'.esc_html__('Layout', 'socialfeeds-pro') .'</span>
						</div>
					</div>
					<div class="socialfeeds-header-right">
						<span class="socialfeeds-chevron dashicons dashicons-arrow-down-alt2"></span>
					</div>
				</div>
				<div class="socialfeeds-accordion-body">
					<div class="socialfeeds-control-group">
						<label class="socialfeeds-control-label">'.esc_html__('LAYOUT TYPE', 'socialfeeds-pro').'</label>
						<div class="socialfeeds-layout-selector">
							<label class="socialfeeds-layout-option">
								<input type="radio" name="instagram_layout" id="socialfeeds-instagram-layout-grid" value="grid" '. checked($settings['instagram_layout'], 'grid', false) .'>
								<div class="layout-box">
									<span class="dashicons dashicons-grid-view"></span>
									<span>'.esc_html__('Grid', 'socialfeeds-pro').'</span>
								</div>
							</label>
							<label class="socialfeeds-layout-option">
								<input type="radio" name="instagram_layout" id="socialfeeds-instagram-layout-carousel" value="carousel" '. checked($settings['instagram_layout'], 'carousel', false) .'>
								<div class="layout-box">
									<span class="dashicons dashicons-images-alt2"></span>
									<span>'.esc_html__('Carousel', 'socialfeeds-pro').'</span>
								</div>
							</label>
							<label class="socialfeeds-layout-option">
								<input type="radio" name="instagram_layout" id="socialfeeds-instagram-layout-masonry" value="masonry" '. checked($settings['instagram_layout'], 'masonry', false) .'>
								<div class="layout-box">
									<span class="dashicons dashicons-layout"></span>
									<span>'.esc_html__('Masonry', 'socialfeeds-pro').'</span>
								</div>
							</label>
						</div>
					</div>

					<div class="socialfeeds-control-group">
						<div class="flex-title">
							<label class="socialfeeds-control-label">'.esc_html__('COLUMNS - DESKTOP', 'socialfeeds-pro').'</label>
							<span class="socialfeeds-value-display">'.esc_html($settings['instagram_columns_desktop']).' Columns</span>
						</div>
						<div class="socialfeeds-range-slider">
							<span class="range-min">1</span>
							<input type="range" name="instagram_columns_desktop" id="socialfeeds-instagram-columns-desktop" min="1" max="6" step="1" value="'.esc_attr($settings['instagram_columns_desktop']).'">
							<span class="range-max">6</span>
						</div>
					</div>

					<div class="socialfeeds-control-group">
						<div class="flex-title">
							<label class="socialfeeds-control-label">'.esc_html__('COLUMNS - MOBILE', 'socialfeeds-pro').'</label>
							<span class="socialfeeds-value-display">'.esc_html($settings['instagram_columns_mobile']).' Columns</span>
						</div>
						<div class="socialfeeds-range-slider">
							<span class="range-min">1</span>
							<input type="range" name="instagram_columns_mobile" id="socialfeeds-instagram-columns-mobile" min="1" max="3" step="1" value="'.esc_attr($settings['instagram_columns_mobile']).'">
							<span class="range-max">3</span>
						</div>
					</div>

					<div class="socialfeeds-control-group">
						<div class="flex-title">
							<label class="socialfeeds-control-label">'.esc_html__('SPACING', 'socialfeeds-pro').'</label>
							<span class="socialfeeds-value-display">'.esc_html($settings['instagram_padding']).'px</span>
						</div>
						<div class="socialfeeds-range-slider">
							<span class="range-min">0</span>
							<input type="range" name="instagram_padding" id="socialfeeds-instagram-padding" min="0" max="100" step="1" value="'.esc_attr($settings['instagram_padding']).'">
							<span class="range-max">100</span>
						</div>
					</div>

					<div class="socialfeeds-control-group">
						<label class="socialfeeds-control-label">
							'.esc_html__('Aspect Ratio', 'socialfeeds-pro').'
						</label>

						<select name="instagram_aspect_ratio" id="socialfeeds-instagram-aspect-ratio" class="socialfeeds-input-full">
							<option value="square" '.selected($settings['instagram_aspect_ratio'], 'square', false).'>
								Square (1:1)
							</option>
							<option value="instagram" '.selected($settings['instagram_aspect_ratio'], 'instagram', false).'>
								Instagram Official (3.4)
							</option>
							<option value="portrait" '.selected($settings['instagram_aspect_ratio'], 'portrait', false).'>
								Portrait (4:5)
							</option>
						</select>
					</div>
				</div>
			</div>

			<!-- Content Limits Accordion -->
			<div class="socialfeeds-accordion-item">
				<div class="socialfeeds-accordion-header">
					<div class="socialfeeds-header-left">
						<div class="socialfeeds-icon-wrap" style="background: #fff7ed; color: #f97316;">
							<span class="dashicons dashicons-filter"></span>
						</div>
						<div class="socialfeeds-title-wrap">
							<span class="socialfeeds-sidebar-title">'.esc_html__('Content Limits', 'socialfeeds-pro').'</span>
						</div>
					</div>
					<div class="socialfeeds-header-right">
						<span class="socialfeeds-chevron dashicons dashicons-arrow-down-alt2"></span>
					</div>
				</div>
				<div class="socialfeeds-accordion-body">
					<div class="socialfeeds-control-group">
						<div class="flex-title">
							<label class="socialfeeds-control-label">'.esc_html__('NUMBER OF POSTS', 'socialfeeds-pro').'</label>
						</div>
						<input type="number" name="instagram_number_posts_desktop" id="socialfeeds-instagram-number-posts-desktop" value="'.esc_attr($settings['instagram_number_posts_desktop']).'" min="1" max="500" class="socialfeeds-input-full">
					</div>


				</div>
			</div>

				<!-- Header Accordion -->
				<div class="socialfeeds-accordion-item">
					<div class="socialfeeds-accordion-header">
						<div class="socialfeeds-header-left">
							<div class="socialfeeds-icon-wrap" style="background: #fdf2f8; color: #db2777;">
								<span class="dashicons dashicons-align-center"></span>
							</div>
							<div class="socialfeeds-title-wrap">
								<span class="socialfeeds-sidebar-title">'.esc_html__('Header', 'socialfeeds-pro').'</span>
							</div>
						</div>
						<div class="socialfeeds-header-right">
							<span class="socialfeeds-chevron dashicons dashicons-arrow-down-alt2"></span>
						</div>
					</div>
					<div class="socialfeeds-accordion-body">
						<div class="socialfeeds-toggle-row">
							<div class="socialfeeds-toggle-info">
								<span class="socialfeeds-toggle-title">'.esc_html__('Enable Header', 'socialfeeds-pro').'</span>
								<span class="socialfeeds-toggle-desc">'.esc_html__('Display feed header with profile info', 'socialfeeds-pro').'</span>
							</div>
							<label class="socialfeeds-switch">
								<input type="checkbox" name="instagram_header_enabled" id="socialfeeds-instagram-header-enabled" value="1" '. checked($settings['instagram_header_enabled'], 1, false) .'>
								<span class="socialfeeds-slider"></span>
							</label>
						</div>
						<div class="socialfeeds-nested-options" style="margin-top:15px;">
							<div class="socialfeeds-control-group">
								<label class="socialfeeds-control-label">'.esc_html__('HEADER Position', 'socialfeeds-pro').'</label>
								<select name="instagram_header_style" id="socialfeeds-instagram-header-style" class="socialfeeds-select-full">
									<option value="left" '. selected($settings['instagram_header_style'], 'left', false) .'>Left</option>
									<option value="middle" '. selected($settings['instagram_header_style'], 'middle', false) .'>Middle</option>
									<option value="right" '. selected($settings['instagram_header_style'], 'right', false) .'>Right</option>
								</select>
							</div>
						<div class="socialfeeds-control-group">
							<label class="socialfeeds-control-label">'.esc_html__('Header Size', 'socialfeeds-pro').'</label>
							<select name="instagram_header_size" id="socialfeeds-instagram-header-size" class="socialfeeds-input-full">
								<option value="small"  '. selected($settings['instagram_header_size'], 'small', false).'>Small</option>
								<option value="medium" '. selected($settings['instagram_header_size'], 'medium', false).'>Medium</option>
								<option value="large"  '. selected($settings['instagram_header_size'], 'large', false).'>Large</option>
							</select>
						</div>
						<div class="socialfeeds-control-group">
							<label class="socialfeeds-control-label">'.esc_html__('Custom Avatar', 'socialfeeds-pro').'</label>
								<div class="socialfeeds-image-uploader">
									<input type="hidden" name="instagram_custom_avatar" id="socialfeeds-custom-avatar-url" value="'.esc_attr(isset($settings['instagram_custom_avatar']) ? $settings['instagram_custom_avatar'] : '').'">
									<div class="socialfeeds-avatar-preview-wrap" style="margin-bottom: 10px; '. (!empty($settings['instagram_custom_avatar']) ? 'display:block;' : 'display:none;') .'">
										<img src="'.esc_url(isset($settings['instagram_custom_avatar']) ? $settings['instagram_custom_avatar'] : '').'" style="width:50px; height:50px; border-radius:50%; object-fit:cover; border:1px solid #ddd;">
									</div>
									<div style="display:flex; gap:10px;">
										<button type="button" class="button socialfeeds-upload-avatar-btn">'.esc_html__('Upload Image', 'socialfeeds-pro').'</button>
										<button type="button" class="button socialfeeds-remove-avatar-btn" style="'. (!empty($settings['instagram_custom_avatar']) ? '' : 'display:none;') .'">'.esc_html__('Remove', 'socialfeeds-pro').'</button>
									</div>
								</div>
							</div>
							<div class="socialfeeds-toggle-row">
								<div class="socialfeeds-toggle-info">
									<span class="socialfeeds-toggle-title">'.esc_html__('Show Bio', 'socialfeeds-pro').'</span>
								</div>
								<label class="socialfeeds-switch">
									<input type="checkbox" name="instagram_show_bio_text" id="socialfeeds-instagram-show-bio-text" value="1" '. checked($settings['instagram_show_bio_text'], 1, false) .'>
									<span class="socialfeeds-slider"></span>
								</label>
							</div>
							<div class="socialfeeds-toggle-row">
								<div class="socialfeeds-toggle-info">
									<span class="socialfeeds-toggle-title">'.esc_html__('Show Followers', 'socialfeeds-pro').'</span>
								</div>
								<label class="socialfeeds-switch">
									<input type="checkbox" name="instagram_show_followers" id="socialfeeds-instagram-show-followers" value="1" '. checked($settings['instagram_show_followers'], 1, false) .'>
									<span class="socialfeeds-slider"></span>
								</label>
							</div>
							<div class="socialfeeds-toggle-row">
								<div class="socialfeeds-toggle-info">
									<span class="socialfeeds-toggle-title">'.esc_html__('Show Media Count', 'socialfeeds-pro').'</span>
								</div>
								<label class="socialfeeds-switch">
									<input type="checkbox" name="instagram_media_count" id="socialfeeds-instagram-media-count" value="1" '. checked($settings['instagram_media_count'], 1, false) .'>
									<span class="socialfeeds-slider"></span>
								</label>
							</div>
						</div>
					</div>
				</div>

				<!-- Post Experience Accordion -->
				<div class="socialfeeds-accordion-item">
					<div class="socialfeeds-accordion-header">
						<div class="socialfeeds-header-left">
							<div class="socialfeeds-icon-wrap" style="background: #e0f2fe; color: #0284c7;">
								<span class="dashicons dashicons-format-image"></span>
							</div>
							<div class="socialfeeds-title-wrap">
								<span class="socialfeeds-sidebar-title">'.esc_html__('Post Experience', 'socialfeeds-pro').'</span>
							</div>
						</div>
						<div class="socialfeeds-header-right">
							<span class="socialfeeds-chevron dashicons dashicons-arrow-down-alt2"></span>
						</div>
					</div>
					<div class="socialfeeds-accordion-body">
						<div class="socialfeeds-control-group">
							<label class="socialfeeds-control-label">'.esc_html__('SORT BY', 'socialfeeds-pro').'</label>
							<select name="instagram_sort_by" id="socialfeeds-instagram-sort-by" class="socialfeeds-select-full">
								<option value="newest" '. selected($settings['instagram_sort_by'], 'newest', false) .'>Newest First</option>
								<option value="likes" '. selected($settings['instagram_sort_by'], 'likes', false) .'>Most Liked</option>
								<option value="random" '. selected($settings['instagram_sort_by'], 'random', false) .'>Random</option>
							</select>
						</div>
						<div class="socialfeeds-toggle-row">
							<div class="socialfeeds-toggle-info">
								<span class="socialfeeds-toggle-title">'.esc_html__('Show Captions', 'socialfeeds-pro').'</span>
							</div>
							<label class="socialfeeds-switch">
								<input type="checkbox" name="instagram_caption_enabled" id="socialfeeds-instagram-caption-enabled" value="1" '. checked($settings['instagram_caption_enabled'], 1, false) .'>
								<span class="socialfeeds-slider"></span>
							</label>
						</div>
						<div class="socialfeeds-toggle-row">
							<div class="socialfeeds-toggle-info">
								<span class="socialfeeds-toggle-title">'.esc_html__('Show Likes', 'socialfeeds-pro').'</span>
							</div>
							<label class="socialfeeds-switch">
								<input type="checkbox" name="instagram_likes" id="socialfeeds-instagram-likes" value="1" '. checked($settings['instagram_likes'], 1, false) .'>
								<span class="socialfeeds-slider"></span>
							</label>
						</div>
						<div class="socialfeeds-toggle-row">
							<div class="socialfeeds-toggle-info">
								<span class="socialfeeds-toggle-title">'.esc_html__('Show Comments', 'socialfeeds-pro').'</span>
							</div>
							<label class="socialfeeds-switch">
								<input type="checkbox" name="instagram_comments" id="socialfeeds-instagram-comments" value="1" '. checked($settings['instagram_comments'], 1, false) .'>
								<span class="socialfeeds-slider"></span>
							</label>
						</div>
						<div class="socialfeeds-toggle-row">
							<div class="socialfeeds-toggle-info">
								<span class="socialfeeds-toggle-title">'.esc_html__('Show Post', 'socialfeeds-pro').'</span>
							</div>
							<label class="socialfeeds-switch">
								<input type="checkbox" name="instagram_show_feed_posts" id="socialfeeds-instagram-show-feed-posts" value="1" '. checked($settings['instagram_show_feed_posts'], 1, false) .'>
								<span class="socialfeeds-slider"></span>
							</label>
						</div>
						<div class="socialfeeds-toggle-row">
							<div class="socialfeeds-toggle-info">
								<span class="socialfeeds-toggle-title">'.esc_html__('Show Reels', 'socialfeeds-pro').'</span>
							</div>
							<label class="socialfeeds-switch">
								<input type="checkbox" name="instagram_show_reels" id="socialfeeds-instagram-show-reels" value="1" '. checked($settings['instagram_show_reels'], 1, false) .'>
								<span class="socialfeeds-slider"></span>
							</label>
						</div>
						<div class="socialfeeds-toggle-row">
							<div class="socialfeeds-toggle-info">
								<span class="socialfeeds-toggle-title">'.esc_html__('Show Play Icon', 'socialfeeds-pro').'</span>
							</div>
							<label class="socialfeeds-switch">
								<input type="checkbox" name="instagram_show_play_icon" id="socialfeeds-instagram-show-play-icon" value="1" '. checked(!isset($settings['instagram_show_play_icon']) || !empty($settings['instagram_show_play_icon']), 1, false) .'>
								<span class="socialfeeds-slider"></span>
							</label>
						</div>
						<div class="socialfeeds-control-group" style="margin-top:15px;">
							<label class="socialfeeds-control-label">'.esc_html__('PLAY MODE', 'socialfeeds-pro').'</label>
							<select name="instagram_play_mode" id="socialfeeds-instagram-play-mode" class="socialfeeds-select-full">
								<option value="newtab" '. selected(isset($settings['instagram_play_mode']) ? $settings['instagram_play_mode'] : 'newtab', 'newtab', false) .'>Open in New Tab</option>
								<option value="lightbox" '. selected(isset($settings['instagram_play_mode']) ? $settings['instagram_play_mode'] : '', 'lightbox', false) .'>Open in Lightbox</option>
								<option value="inline" '. selected(isset($settings['instagram_play_mode']) ? $settings['instagram_play_mode'] : '', 'inline', false) .'>Play Inline</option>
							</select>
						</div>
						<div class="socialfeeds-control-group" style="margin-top:15px;">
							<label class="socialfeeds-control-label">'.esc_html__('HOVER STATE', 'socialfeeds-pro').'</label>
							<select name="instagram_hover_state" id="socialfeeds-instagram-hover-state" class="socialfeeds-select-full">
								<option value="overlay" '. selected($settings['instagram_hover_state'], 'overlay', false) .'>Overlay</option>
								<option value="scale" '. selected($settings['instagram_hover_state'], 'scale', false) .'>Scale</option>
								<option value="shadow" '. selected($settings['instagram_hover_state'], 'shadow', false) .'>Shadow</option>
								<option value="none" '. selected($settings['instagram_hover_state'], 'none', false) .'>None</option>
							</select>
						</div>
					</div>
				</div>

				<!-- Follow Button -->
				<div class="socialfeeds-accordion-item">
					<div class="socialfeeds-accordion-header">
						<div class="socialfeeds-header-left">
							<div class="socialfeeds-icon-wrap" style="background: #f0fdf4; color: #16a34a;">
								<span class="dashicons dashicons-rss"></span>
							</div>
							<div class="socialfeeds-title-wrap">
								<span class="socialfeeds-sidebar-title">'.esc_html__('Follow Button', 'socialfeeds-pro').'</span>
							</div>
						</div>
						<div class="socialfeeds-header-right">
							<span class="socialfeeds-chevron dashicons dashicons-arrow-down-alt2"></span>
						</div>
					</div>
					<div class="socialfeeds-accordion-body">
						<div class="socialfeeds-toggle-row">
							<div class="socialfeeds-toggle-info">
								<span class="socialfeeds-toggle-title">'.esc_html__('Follow Button', 'socialfeeds-pro').'</span>
							</div>
							<label class="socialfeeds-switch">
								<input type="checkbox" name="instagram_follow_button_enabled" id="socialfeeds-instagram-follow-button-enabled" value="1" '. checked($settings['instagram_follow_button_enabled'], 1, false) .'>
								<span class="socialfeeds-slider"></span>
							</label>
						</div>
						<div class="socialfeeds-nested-options" style="margin-top:15px;">
							<div class="socialfeeds-control-group">
								<label class="socialfeeds-control-label">'.esc_html__('BUTTON TEXT', 'socialfeeds-pro').'</label>
								<input type="text" name="instagram_follow_button_text" id="socialfeeds-instagram-follow-button-text" value="'.esc_attr($settings['instagram_follow_button_text']).'" class="socialfeeds-input-full">
							</div>
							<div class="socialfeeds-control-group">
								<label class="socialfeeds-control-label">'.esc_html__('BUTTON COLORS', 'socialfeeds-pro').'</label>
								<div style="display: flex; gap: 10px; margin-top: 5px;">
									<div style="flex: 1;">
										<label style="font-size: 10px; opacity: 0.7; display: block; margin-bottom: 4px;">'.esc_html__('BG', 'socialfeeds-pro').'</label>
										<input type="color" name="instagram_follow_button_bg_color" id="socialfeeds-instagram-follow-button-bg-color" value="'.esc_attr($settings['instagram_follow_button_bg_color']).'" class="socialfeeds-color-input">
									</div>
									<div style="flex: 1;">
										<label style="font-size: 10px; opacity: 0.7; display: block; margin-bottom: 4px;">'.esc_html__('TEXT', 'socialfeeds-pro').'</label>
										<input type="color" name="instagram_follow_button_text_color" id="socialfeeds-instagram-follow-button-text-color" value="'.esc_attr($settings['instagram_follow_button_text_color']).'" class="socialfeeds-color-input">
									</div>
									<div style="flex: 1;">
										<label style="font-size: 10px; opacity: 0.7; display: block; margin-bottom: 4px;">'.esc_html__('HOVER', 'socialfeeds-pro').'</label>
										<input type="color" name="instagram_follow_button_hover_color" id="socialfeeds-instagram-follow-button-hover-color" value="'.esc_attr($settings['instagram_follow_button_hover_color']).'" class="socialfeeds-color-input">
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
				
				<!-- Load More Accordion -->
				<div class="socialfeeds-accordion-item">
					<div class="socialfeeds-accordion-header">
						<div class="socialfeeds-header-left">
							<div class="socialfeeds-icon-wrap" style="background: #faf5ff; color: #a855f7;">
								<span class="dashicons dashicons-plus-alt"></span>
							</div>
							<div class="socialfeeds-title-wrap">
								<span class="socialfeeds-sidebar-title">'.esc_html__('Load More', 'socialfeeds-pro').'</span>
							</div>
						</div>
						<div class="socialfeeds-header-right">
							<span class="socialfeeds-chevron dashicons dashicons-arrow-down-alt2"></span>
						</div>
					</div>
					<div class="socialfeeds-accordion-body">
						<div class="socialfeeds-toggle-row">
							<div class="socialfeeds-toggle-info">
								<span class="socialfeeds-toggle-title">'.esc_html__('Load More Button', 'socialfeeds-pro').'</span>
							</div>
							<label class="socialfeeds-switch">
								<input type="checkbox" name="instagram_load_more_enabled" id="socialfeeds-instagram-load-more-enabled" value="1" '. checked($settings['instagram_load_more_enabled'], 1, false) .'>
								<span class="socialfeeds-slider"></span>
							</label>
						</div>
						<div class="socialfeeds-control-group">
							<label class="socialfeeds-control-label">'. esc_html__('POSTS PER LOAD', 'socialfeeds-pro').'</label>
							<input type="number" name="instagram_load_more_count" id="socialfeeds-instagram-load-more-count" value="'.(!empty($settings['instagram_load_more_count']) ? esc_attr($settings['instagram_load_more_count']) : 12).'" min="1" class="socialfeeds-input-full">
							<small style="opacity:0.7;">How many posts load each time</small>
						</div>
						<div class="socialfeeds-nested-options" style="margin-top:15px;">
							<div class="socialfeeds-control-group">
								<label class="socialfeeds-control-label">'.esc_html__('BUTTON TEXT', 'socialfeeds-pro').'</label>
								<input type="text" name="instagram_load_more_text" id="socialfeeds-instagram-load-more-text" value="'.esc_attr($settings['instagram_load_more_text']).'" class="socialfeeds-input-full">
							</div>
							<div class="socialfeeds-control-group">
								<label class="socialfeeds-control-label">'.esc_html__('BUTTON COLORS', 'socialfeeds-pro').'</label>
								<div style="display: flex; gap: 10px; margin-top: 5px;">
									<div style="flex: 1;">
										<label style="font-size: 10px; opacity: 0.7; display: block; margin-bottom: 4px;">'.esc_html__('BG', 'socialfeeds-pro').'</label>
										<input type="color" name="instagram_load_more_bg_color" id="socialfeeds-instagram-load-more-bg-color" value="'.esc_attr($settings['instagram_load_more_bg_color']).'" class="socialfeeds-color-input">
									</div>
									<div style="flex: 1;">
										<label style="font-size: 10px; opacity: 0.7; display: block; margin-bottom: 4px;">'.esc_html__('TEXT', 'socialfeeds-pro').'</label>
										<input type="color" name="instagram_load_more_text_color" id="socialfeeds-instagram-load-more-text-color" value="'.esc_attr($settings['instagram_load_more_text_color']).'" class="socialfeeds-color-input">
									</div>
									<div style="flex: 1;">
										<label style="font-size: 10px; opacity: 0.7; display: block; margin-bottom: 4px;">'.esc_html__('HOVER', 'socialfeeds-pro').'</label>
										<input type="color" name="instagram_load_more_hover_color" id="socialfeeds-instagram-load-more-hover-color" value="'.esc_attr($settings['instagram_load_more_hover_color']).'" class="socialfeeds-color-input">
									</div>
								</div>
							</div>
						</div>
					</div>
			</div>
		</div></div>';
	}

	static function render_instagram_sidebar_style($settings) {
	
		echo '<div id="socialfeeds-tab-style" class="socialfeeds-sidebar-tab-pane">
			<div class="socialfeeds-sidebar-header">
				<h3>'. esc_html__('Style Settings', 'socialfeeds-pro').'</h3>
			</div>
			
			<!-- Color Scheme Accordion -->
			<div class="socialfeeds-accordion-wrapper">
			<div class="socialfeeds-accordion-item">
				<div class="socialfeeds-accordion-header">
					<div class="socialfeeds-header-left">
						<div class="socialfeeds-icon-wrap" style="background: #f0fdfa; color: #0d9488;">
							<span class="dashicons dashicons-art"></span>
						</div>
						<div class="socialfeeds-title-wrap">
							<span class="socialfeeds-sidebar-title">'. esc_html__('Color Scheme', 'socialfeeds-pro') .'</span>
						</div>
					</div>
					<div class="socialfeeds-header-right">
						<span class="socialfeeds-chevron dashicons dashicons-arrow-down-alt2"></span>
					</div>
				</div>
				<div class="socialfeeds-accordion-body">
					<div class="socialfeeds-control-group">
						<label class="socialfeeds-control-label">'. esc_html__('COLOR SCHEME', 'socialfeeds-pro') .'</label>
						<select name="instagram_color_scheme" id="socialfeeds-instagram-color-scheme" class="socialfeeds-select-full">
							<option value="light" '. selected($settings['instagram_color_scheme'], 'light', false) .'>'.esc_html__('Light', 'socialfeeds-pro').'</option>
							<option value="dark" '. selected($settings['instagram_color_scheme'], 'dark', false) .'>'.esc_html__('Dark', 'socialfeeds-pro').'</option>
							<option value="custom" '. selected($settings['instagram_color_scheme'], 'custom', false) .'>'.esc_html__('Custom', 'socialfeeds-pro').'</option>
						</select>
					</div>
					<div class="socialfeeds-control-group" id="socialfeeds-custom-color-group" style="'.('custom' !== $settings['instagram_color_scheme'] ? 'display:none;' : '').'">
						<label class="socialfeeds-control-label">'.esc_html__('CUSTOM BG COLOR', 'socialfeeds-pro').'</label>
						<input type="color" name="instagram_custom_color" id="socialfeeds-instagram-custom-color" value="'.esc_attr($settings['instagram_custom_color']).'" class="socialfeeds-color-input">
					</div>
				</div>
			</div>


			</div> <!-- End Accordion Wrapper -->
		</div>';
	}

	static function render_instagram_embed_modal() {
		echo '<div id="socialfeeds-embed-modal" class="socialfeeds-embed-modal">
			<div class="socialfeeds-embed-container" style="max-width: 800px; width: 90%; background: #fff; border-radius: 16px; position: relative;">
				<button id="socialfeeds-embed-close" class="socialfeeds-embed-close" style="position: absolute; right: 20px; top: 20px; border: none; background: none; font-size: 24px; cursor: pointer;">&times;</button>
				<div class="socialfeeds-embed-content" style="padding: 40px;">
					<h2 style="margin-top:0;">' . esc_html__('Embed Feed', 'socialfeeds-pro') . '</h2>
					<p style="color:#64748b; margin-bottom:25px;">' . esc_html__('Copy the shortcode and paste it into your page or post editor.', 'socialfeeds-pro') . '</p>
					
					<div class="socialfeeds-embed-shortcode-wrap" style="display:flex; gap:10px; margin-bottom:30px; background:#f8fafc; padding:15px; border-radius:12px; border:1px solid #e2e8f0;">
						<input type="text" id="socialfeeds-embed-shortcode" readonly value="" style="flex:1; background:transparent; border:none; font-family:monospace; font-size:16px; color:#1e293b;" />
						<button id="socialfeeds-embed-copy" class="socialfeeds-btn-sync" style="padding:8px 25px;">' . esc_html__('Copy', 'socialfeeds-pro') . '</button>
					</div>

					<div class="socialfeeds-preview-header-bar" style="border-radius:12px 12px 0 0;">
						<span class="socialfeeds-preview-label">'.esc_html__('EMBED PREVIEW', 'socialfeeds-pro').'</span>
						<div class="socialfeeds-preview-device-toggles">
							<button type="button" class="socialfeeds-preview-device active" data-width="100%"><span class="dashicons dashicons-desktop"></span></button>
							<button type="button" class="socialfeeds-preview-device" data-width="768"><span class="dashicons dashicons-tablet"></span></button>
						</div>
					</div>
					<div id="socialfeeds-embed-preview-wrap" style="background:#f1f5f9; padding:20px; border-radius:0 0 12px 12px; max-height:400px; overflow-y:auto;">
						<div id="socialfeeds-preview-grid-clone"></div>
					</div>
				</div>
			</div>
		</div>';
	}
}