jQuery(document).ready(function ($) {
    let selected_type = null,
    current_posts = [],
    current_account = null,
    socialfeeds_filtered_posts = [],
    socialfeeds_visible_count = 0,
    fetch_and_update_preview; // Define in scope

    // Initialize global sort if not exists
    window.socialfeeds_current_sort = 'newest';
    window.socialfeeds_preview_device = 'desktop';

    function show_toast(message, type = 'success') {
        let toast = $('<div>')
            .addClass('socialfeeds-toast')
            .addClass(type)
            .html(`<span class="dashicons dashicons-yes"></span> ${message}`);

        $('body').append(toast);
        toast.fadeIn(300).delay(3000).fadeOut(300, function () {
            toast.remove();
        });
    }

    // validate insta access token
    $('#socialfeeds-ig-validate-btn').on('click', function (e) {
        e.preventDefault();
        let button = $(this),
        token = $('#socialfeeds-ig-token-input').val() || '';
        token = token.trim();
        // Token empty check
        if (!token) {
            $('#socialfeeds-standalone-token-message').show().css('color', 'red').text('Please paste a long-lived access token.');
            return;
        }

        // Disable button while validating
        button.prop('disabled', true).text('Validating...');

        $.ajax({
            url: socialfeeds_pro.ajax_url,
            type: 'POST',
            dataType: 'json',
            data: {
                action: 'socialfeeds_pro_validate_instagram_token',
                access_token: token,
                nonce: socialfeeds_pro.nonce
            },
            success: function (resp) {
                if (resp && resp.success) {
                    window.location.href = socialfeeds_pro.ajax_url.replace('admin-ajax.php', '') + 'admin.php?page=socialfeeds&action=create&connection_type=manual#instagram';
                } else {
                    let msg = (resp && resp.data && resp.data.message) ? resp.data.message : 'Token validation failed'
                    $('#socialfeeds-standalone-token-message').show().css('color', 'red').text(msg);
                }
            },
            error: function () {
                $('#socialfeeds-standalone-token-message').show().css('color', 'red').text('Network error validating token');
            },
            complete: function () {
                button.prop('disabled', false).text('Validate & Connect');
            }
        });
    });

    // Add Extra account vaildate
    $('#socialfeeds-wizard-validate-token-btn').on('click', function (e) {
        e.preventDefault();

        let token = $('#socialfeeds-wizard-token-input').val().trim(),
        btn = $(this),
        msg_div = $('#socialfeeds-wizard-token-message');

        if (!token) {
            msg_div.show().css('color', '#d32f2f').text('Please enter an access token').fadeIn();
            return;
        }

        btn.prop('disabled', true).text('Validating...');

        $.ajax({
            url: socialfeeds_pro.ajax_url,
            type: 'POST',
            dataType: 'json',
            data: {
                action: 'socialfeeds_pro_validate_instagram_token',
                access_token: token,
                nonce: socialfeeds_pro.nonce
            },
            success: function (resp) {
                if (resp && resp.success) {
                    msg_div.show().css('color', '#4caf50').text('✓ Account connected! Reloading...').fadeIn();
                    location.reload();

                } else {
                    let msg = (resp && resp.data && resp.data.message) ? resp.data.message : 'Token validation failed'
                    msg_div.show().css('color', 'red').text(msg).fadeIn();
                }
            },
            error: function (xhr) {
                btn.prop('disabled', false).text('Validate & Connect');
                let errmsg = (xhr.responseJSON && xhr.responseJSON.data && xhr.responseJSON.data.message) ? xhr.responseJSON.data.message : 'Network error';
                msg_div.show().css('color', '#d32f2f').text('✗ Error: ' + errmsg).fadeIn();
            },
            complete: function () {
                btn.prop('disabled', false).text('Validate & Connect');
            }
        });

    });

    $('input[name="instagram_layout"]').on('change', function () {
        if (current_posts.length > 0) { render_preview_grid(current_posts, get_instagram_settings()); }
    });

    // Instagram Feed Type Card Selection
    $('.socialfeeds-feed-type-card, .socialfeeds-type-card').on('click', function () {
        if ($(this).hasClass('socialfeeds-locked')) return;
        selected_type = $(this).data('type');
        $('#socialfeeds-select-type-btn-instagram').removeClass('socialfeeds-disabled');
    });

    $('#socialfeeds-select-type-btn-instagram').on('click', function (e) {
        e.preventDefault();
        if (!selected_type) return;
        let url = 'admin.php?page=socialfeeds&action=create&type=' + encodeURIComponent(selected_type) + '#instagram';
        window.location.href = url;
    });

    // Manual Account Connect
    $('#socialfeeds-add-new-account-btn').on('click', function (e) {
        e.preventDefault();
        $('#socialfeeds-new-account-form').slideDown();
        $('#socialfeeds-manual-token-input').focus();
    });

    $('#socialfeeds-cancel-new-account-btn, #socialfeeds-cancel-manual-token-btn').on('click', function (e) {
        e.preventDefault();
        $('#socialfeeds-new-account-form').slideUp();
        $('#socialfeeds-token-message').hide().text('');
    });

    $('#socialfeeds-validate-token-btn').on('click', function (e) {
        e.preventDefault();
        let btn = $(this),
        token = $('#socialfeeds-manual-token-input').val() || '';
        token = token.trim();
        if (!token) {
            $('#socialfeeds-token-message').show().css('color', 'red').text('Please paste a long-lived access token.');
            return;
        }

        btn.prop('disabled', true).text('Validating...');
        $.post(socialfeeds_pro.ajax_url, {
            action: 'socialfeeds_pro_validate_instagram_token', // Use Pro action
            access_token: token,
            nonce: socialfeeds_pro.nonce
        }, function (resp) {
            if (resp && resp.success && resp.data && resp.data.account) {
                let acc = resp.data.account;
                location.reload();
            } else {
                let msg = (resp && resp.data && resp.data.message) ? resp.data.message : 'Token validation failed';
                $('#socialfeeds-token-message').show().css('color', 'red').text(msg);
            }
        }, 'json').fail(function () {
            $('#socialfeeds-token-message').show().css('color', 'red').text('Network error validating token');
        }).always(function () {
            btn.prop('disabled', false).text('✓ Validate & Connect');
        });
    });

    $('.socialfeeds-account-item').on('click', function (e) {
        let $r = $(this).find('input[type="radio"]');
        if ($r.length) {
            $r.prop('checked', true).trigger('change');
        }
    });

    // Step Navigation
    $('.socialfeeds-step-next-btn').on('click', function (e) {
        e.preventDefault();
        let next_step = $(this).data('next-step');
        $('.socialfeeds-wizard-step').removeClass('active').hide();
        $('#socialfeeds-step-' + next_step).addClass('active').show();
        window.scrollTo({ top: 0, behavior: 'smooth' });
    });

    $('.socialfeeds-step-back-btn').on('click', function (e) {
        e.preventDefault();
        let back_step = $(this).data('back-step');
        $('.socialfeeds-wizard-step').removeClass('active').hide();
        $('#socialfeeds-step-' + back_step).addClass('active').show();
        window.scrollTo({ top: 0, behavior: 'smooth' });
    });

    // Wizard Token Form
    $('#socialfeeds-wizard-add-account-btn').on('click', function (e) {
        e.preventDefault();
        $('#socialfeeds-wizard-token-form').slideDown();
        $('#socialfeeds-wizard-token-input').focus();
    });

    $('#socialfeeds-wizard-cancel-token-btn').on('click', function (e) {
        e.preventDefault();
        $('#socialfeeds-wizard-token-form').slideUp();
        $('#socialfeeds-wizard-token-input').val('');
        $('#socialfeeds-wizard-token-message').hide().text('');
    });

    // Source Type selection
    $('input[name="instagram_source_type"]').on('change', function () {
        let type = $(this).val(),
        label_el = $('#socialfeeds-source-label'),
        help_el = $('#socialfeeds-source-help');
        input_el = $('#socialfeeds-source-input-field');

        if (type === 'hashtag') {
            label_el.text('Hashtag');
            help_el.text('Enter hashtag name (without #)');
            input_el.attr('placeholder', 'travel, photography, food...');
        } else if (type === 'tagged') {
            label_el.text('Username/ID');
            help_el.text('Enter username or ID to find posts tagging this account');
            input_el.attr('placeholder', 'username or account_id');
        } else {
            label_el.text('Username/ID');
            help_el.text('Enter the Instagram username or account ID');
            input_el.attr('placeholder', 'username or account_id');
        }
    });

    function get_current_device() {
        let $activeBtn = $('#socialfeeds-instagram .socialfeeds-preview-device-btn.active');
        if ($activeBtn.length) {
            let width = parseInt($activeBtn.data('width'));
            if (width === 375) return 'mobile';
            if (width === 768) return 'tablet';
            return 'desktop';
        }
        return window.socialfeeds_instagram_device || window.socialfeeds_preview_device || 'desktop';
    }

    function get_responsive_post_limit(settings) {
        let device = get_current_device();

        if (device === 'mobile') {
            return parseInt(settings.instagram_number_posts_mobile) || 6;
        }

        if (device === 'tablet') {
            return parseInt(
                settings.instagram_number_posts_tablet ||
                settings.instagram_number_posts_desktop
            ) || 8;
        }

        return parseInt(settings.instagram_number_posts_desktop) || 12;
    }

    // Preview rendering
    // Carousel Controls Init (YouTube Style)
    function init_carousel_controls($grid) {
        // Clean up previous init
        let $wrapper = $grid.parent();
        if ($wrapper.hasClass('socialfeeds-carousel-stage')) {
            // Already wrapped, just remove controls to re-add
            $wrapper.find('.socialfeeds-carousel-nav').remove();
            $wrapper.parent().find('.socialfeeds-carousel-dots').remove();
        } else {
            // Wrap it
            $grid.wrap('<div class="socialfeeds-carousel-stage" style="position:relative;"></div>');
            $wrapper = $grid.parent();
        }
        // $wrapper is now the stage

        let $nav = $(`
            <div class="socialfeeds-carousel-nav">
                <button class="socialfeeds-carousel-btn prev"><span class="dashicons dashicons-arrow-left-alt2" style="font-family:dashicons; line-height:inherit;"></span></button>
                <button class="socialfeeds-carousel-btn next"><span class="dashicons dashicons-arrow-right-alt2" style="font-family:dashicons; line-height:inherit;"></span></button>
            </div>
        `);
        $wrapper.append($nav);

        let count = $grid.children().length,
        items_per_page = 3; // Default

        if ($grid.find('.socialfeeds-preview-item').first().length) {
            let itemW = $grid.find('.socialfeeds-preview-item').first().outerWidth(),
            gridW = $grid.width();
            if (itemW > 0 && gridW > 0) {
                items_per_page = Math.round(gridW / itemW);
                if (items_per_page < 1) items_per_page = 1;
            }
        }

        let total_pages = Math.ceil(count / items_per_page),
        $dots = $('<div class="socialfeeds-carousel-dots"></div>');

        for (let i = 0; i < total_pages; i++) {
            let $dot = $('<span class="socialfeeds-dot"></span>');
            if (i === 0) $dot.addClass('active');

            $dot.on('click', () => {
                $grid[0].scrollTo({
                    left: i * ($grid.width()),
                    behavior: 'smooth'
                });
                $dots.find('.socialfeeds-dot').removeClass('active');
                $dot.addClass('active');
            });
            $dots.append($dot);
        }

        $wrapper.after($dots);

        $nav.find('.next').on('click', (e) => {
            e.preventDefault();
            $grid[0].scrollBy({ left: $grid.width(), behavior: 'smooth' });
        });
        $nav.find('.prev').on('click', (e) => {
            e.preventDefault();
            $grid[0].scrollBy({ left: -$grid.width(), behavior: 'smooth' });
        });

        // Update dots on scroll
        $grid.on('scroll', function () {
            let page = Math.round($grid.scrollLeft() / $grid.width());
            $dots.find('.socialfeeds-dot').removeClass('active').eq(page).addClass('active');
        });
    }

    function render_preview_grid(posts, settings) {
        if (!posts || posts.length === 0) {
            $('#socialfeeds-instagram-preview-grid').html('<div class="socialfeeds-no-preview">No posts available</div>');
            // Cleanup carousel if exists
            let $p = $('#socialfeeds-instagram-preview-grid').parent();
            if ($p.hasClass('socialfeeds-carousel-stage')) {
                $p.find('.socialfeeds-carousel-nav').remove();
                $p.siblings('.socialfeeds-carousel-dots').remove();
                $('#socialfeeds-instagram-preview-grid').unwrap();
            }
            return;
        }

        let padding = parseInt(settings.instagram_padding, 10) || 8,
        post_limit = get_responsive_post_limit(settings);

        /* FILTER POSTS (POST vs REEL) */
        const filtered = posts.filter(function (post) {
            let media_type = (post.media_type || '').toUpperCase(),
            permalink = post.permalink || '',
            is_reel = post.is_reel === true || (post.permalink && post.permalink.includes('/reel/')) || post.media_type === 'REEL',
            is_post = !is_reel;

            if (!settings.instagram_show_feed_posts && is_post) return false;
            if (!settings.instagram_show_reels && is_reel) return false;
            return true;
        });

        if (filtered.length === 0) {
            $('#socialfeeds-instagram-preview-grid').html(
                '<div class="socialfeeds-no-preview">No posts to display</div>'
            );
            // Cleanup carousel if exists
            let $p = $('#socialfeeds-instagram-preview-grid').parent();
            if ($p.hasClass('socialfeeds-carousel-stage')) {
                $p.find('.socialfeeds-carousel-nav').remove();
                $p.siblings('.socialfeeds-carousel-dots').remove();
                $('#socialfeeds-instagram-preview-grid').unwrap();
            }
            return;
        }
        socialfeeds_filtered_posts = filtered;

        if (typeof socialfeeds_visible_count === 'undefined' || socialfeeds_visible_count === 0) {
            socialfeeds_visible_count = post_limit;
        }
        const display_posts = socialfeeds_filtered_posts.slice(0, socialfeeds_visible_count);
        let html = '';
        display_posts.forEach(function (post) {
            let media_type = post.media_type ? post.media_type.toUpperCase() : 'IMAGE';
            media_url = post.media_url || '',
            thumbnail_url = post.thumbnail_url || '',
            permalink = post.permalink || '';
            html += '<div class="socialfeeds-preview-item hover-' + settings.instagram_hover_state + '" data-permalink="' + permalink + '" data-media-url="' + media_url + '" data-media-type="' + media_type + '">';

            /* MEDIA */
            let aspect_class = settings.instagram_layout === 'masonry' ? 'auto' : settings.instagram_aspect_ratio;
            if (settings.instagram_aspect_ratio === 'instagram') {
                aspect_class = (post.is_reel || media_type === 'VIDEO') ? 'portrait' : 'square';
            }

            html += '<div class="socialfeeds-preview-media aspect-' + aspect_class + '" style="position:relative; overflow:hidden;">';

            if (media_type === 'VIDEO') {
                let thumbnail = thumbnail_url || media_url;
                if (thumbnail && !thumbnail.endsWith('.mp4')) {
                    html += '<img src="' + thumbnail + '" alt="Video">';
                } else {
                    html += '<div class="socialfeeds-video-placeholder">📹 Video</div>';
                }
            } else if (media_url && !media_url.endsWith('.mp4')) {
                html += '<img src="' + media_url + '" alt="Post">';
            } else {
                html += '<div class="socialfeeds-video-placeholder">📷 No image</div>';
            }

            if (settings.instagram_hover_state === 'overlay') {
                html += '<div class="socialfeeds-hover-overlay"></div>';
            }

            if (media_type === 'VIDEO' && settings.instagram_show_play_icon) {
                html += '<span class="socialfeeds-play-overlay"><span class="dashicons dashicons-arrow-right"></span></span>';
            }

            html += '</div>'; // media

            html += '<div class="socialfeeds-preview-stats">';
            if (settings.instagram_caption_enabled && post.caption) {
                html += '<div class="caption">' + post.caption + '</div>';
            }
            if (settings.instagram_likes && post.like_count !== undefined) {
                html += '<span class="likes"><span class="dashicons dashicons-heart socialfeeds-likes"></span> ' + post.like_count + '</span>';
            }
            if (settings.instagram_comments && post.comments_count !== undefined) {
                html += '<span class="comments"><span class="dashicons dashicons-admin-comments socialfeeds-comments"></span> ' + post.comments_count + '</span>';
            }
            html += '</div>'; // stats
            html += '</div>'; // item
        });

        let preview_box = $('#socialfeeds-instagram-preview-grid');
        preview_box.html(html);

        // Apply Color Scheme (like YouTube)
        let $preview_wrapper = $('.socialfeeds-preview-box-wrapper'),
        color_scheme = settings.instagram_color_scheme || 'light',
        custom_color = settings.instagram_custom_color || '#000000';

        if (color_scheme === 'dark') {
            $preview_wrapper.css({ background: '#0f0f0f', padding: '20px', borderRadius: '8px' });
        } else if (color_scheme === 'light') {
            $preview_wrapper.css({ background: '#ffffff', padding: '20px', borderRadius: '8px', border: '1px solid #eeeeee' });
        } else if (color_scheme === 'custom') {
            $preview_wrapper[0].style.setProperty('background', custom_color, 'important');
            $preview_wrapper.css({ padding: '20px', borderRadius: '8px' });
        } else {
            $preview_wrapper.css({ background: '', padding: '', borderRadius: '', border: '' });
        }

        // Determine if dark mode for text colors
        let is_dark = (color_scheme === 'dark');
        if (color_scheme === 'custom') {
            is_dark = (function (hex) {
                if (!hex || hex.indexOf('#') !== 0) return false;
                let r = parseInt(hex.slice(1, 3), 16),
                g = parseInt(hex.slice(3, 5), 16),
                b = parseInt(hex.slice(5, 7), 16);
                return (r * 0.299 + g * 0.587 + b * 0.114) < 128;
            })(custom_color);
        }

        // Apply text colors based on scheme
        let text_color = is_dark ? '#ffffff' : '#1d2327',
        meta_color = is_dark ? '#cccccc' : '#606060';

        preview_box.find('.socialfeeds-preview-stats').css('color', text_color);
        preview_box.find('.socialfeeds-preview-stats .caption').css('color', text_color);
        preview_box.find('.socialfeeds-preview-stats .likes, .socialfeeds-preview-stats .comments, .socialfeeds-preview-stats .views').css('color', meta_color);

        //Header
        let $header = $('#socialfeeds-instagram-preview-header');
        $header.find('.preview-username').css('color', text_color);
        $header.find('.preview-bio, .preview-followers, .preview-media').css('color', meta_color);

        // Clear previous layout classes
        preview_box.removeClass('layout-grid layout-carousel layout-masonry');

        // Apply layout style
        if (settings.instagram_layout === 'carousel') {
            preview_box.addClass('layout-carousel');

            let items_to_show = get_preview_columns(settings);
            if (items_to_show < 1) items_to_show = 1;

            let item_width_calc = `calc((100% - ${(items_to_show - 1) * padding}px) / ${items_to_show})`;

            preview_box.css({
                display: 'flex',
                gap: padding + 'px',
                overflowX: 'hidden',
                scrollBehavior: 'smooth'
            });
            // Reset others
            preview_box.css({
                'column-count': '',
                'grid-template-columns': '',
                'display': 'flex'
            });

            preview_box.find('.socialfeeds-preview-item').css({
                flex: '0 0 ' + item_width_calc,
                maxWidth: item_width_calc
            });

            init_carousel_controls(preview_box);

        } else { // Not Carousel
            // Cleanup carousel wrapper/controls
            let $parent = preview_box.parent();
            if ($parent.hasClass('socialfeeds-carousel-stage')) {
                $parent.find('.socialfeeds-carousel-nav').remove();
                $parent.siblings('.socialfeeds-carousel-dots').remove();
                preview_box.unwrap(); // Removes .socialfeeds-carousel-stage
            } else {
                preview_box.parent().find('.socialfeeds-carousel-nav, .socialfeeds-carousel-dots').remove();
                preview_box.siblings('.socialfeeds-carousel-dots').remove();
            }

            preview_box.find('.socialfeeds-preview-item').css({ flex: '', maxWidth: '' });
            preview_box.css({ overflowX: '', scrollBehavior: '' });

            if (settings.instagram_layout === 'masonry') {
                preview_box.addClass('layout-masonry').css({
                    columnGap: padding + 'px',
                    display: 'block'
                });
                preview_box.find('.socialfeeds-preview-item').css({
                    width: '100%',
                    display: 'inline-block',
                    marginBottom: padding + 'px',
                    breakInside: 'avoid',
                    pageBreakInside: 'avoid'
                });
                function update_masonry_cols() {
                    let cols = get_preview_columns(settings);
                    preview_box.css('column-count', cols);
                }
                update_masonry_cols();
            }
            else { // grid layout
                preview_box.addClass('layout-grid').css({
                    display: 'grid',
                    gap: padding + 'px'
                });

                function update_grid_cols() {
                    let cols = get_preview_columns(settings);
                    preview_box.css('grid-template-columns', 'repeat(' + cols + ', 1fr)');
                }
                update_grid_cols();
            }
        }

        // Buttons Container
        if (settings.instagram_follow_button_enabled || settings.instagram_load_more_enabled) {
            let buttons_html = '<div class="socialfeeds-preview-actions" style="grid-column: 1 / -1; display: flex; justify-content: center; gap: 10px; margin-top: 20px; width: 100%; flex-wrap: wrap;">';

            if (settings.instagram_load_more_enabled) {
                // Create unique class for hover
                let loadMoreBtnClass = 'socialfeeds-load-more-btn-' + Date.now();

                buttons_html += `
                <button type="button" class="button socialfeeds-load-more-btn ${loadMoreBtnClass}" 
                    id="socialfeeds-load-more-btn"
                    data-load-count="${settings.instagram_load_more_count}"
                    style="background: ${settings.instagram_load_more_bg_color}; 
                        color: ${settings.instagram_load_more_text_color};">
                    ${settings.instagram_load_more_text}
                </button>
                <style>
                    .${loadMoreBtnClass}:hover {
                        background: ${settings.instagram_load_more_hover_color} !important;
                    }
                </style>
            `;
            }

            if (settings.instagram_follow_button_enabled) {
                let ig_username = current_account ? current_account.username : '',
                ig_url = ig_username ? `https://www.instagram.com/${ig_username}/` : 'https://www.instagram.com/',
                followBtnClass = 'socialfeeds-follow-btn-' + Date.now();
                buttons_html += `
                <a href="${ig_url}" target="_blank" class="button ${followBtnClass}" 
                    style="background: ${settings.instagram_follow_button_bg_color}; 
                        color: ${settings.instagram_follow_button_text_color}; 
                        display: inline-flex; align-items: center; gap: 6px; border: none; text-decoration: none;">
                    <span class="dashicons dashicons-instagram" style="font-size: 18px; width: 18px; height: 18px; line-height: 1;"></span>
                    ${settings.instagram_follow_button_text}
                </a>
                <style>
                    .${followBtnClass}:hover {
                        background: ${settings.instagram_follow_button_hover_color} !important;
                    }
                </style>
            `;
            }

            buttons_html += '</div>';

            // Clear existing
            $('.socialfeeds-preview-actions').remove();

            if (settings.instagram_layout === 'carousel') {
                let $stage = preview_box.parent(),
                $dots = $stage.next('.socialfeeds-carousel-dots');
                if ($dots.length) {
                    $dots.after(buttons_html);
                } else {
                    $stage.after(buttons_html);
                }
            } else if (settings.instagram_layout === 'masonry') {
                preview_box.after(buttons_html);
            } else {
                preview_box.append(buttons_html);
            }
        }

        if (settings.instagram_load_more_enabled && socialfeeds_visible_count < socialfeeds_filtered_posts.length) {
            $('.socialfeeds-load-more-btn').show();
        }
        preview_box.show();
    }

    function get_preview_columns(settings) {
        let device = get_current_device();

        if (device === 'mobile') {
            return parseInt(settings.instagram_columns_mobile) || 1;
        }
        if (device === 'tablet') {
            return parseInt(settings.instagram_columns_tablet) || 2;
        }
        return parseInt(settings.instagram_columns_desktop) || 3;
    }


    fetch_and_update_preview = function () {
        let selected_account_index = $('input[name="instagram_selected_account"]:checked').val();
        if (selected_account_index === undefined) {
            $('#socialfeeds-instagram-preview-grid').html('<div class="socialfeeds-no-preview">Please select an account</div>');
            return;
        }

        let feed_type = socialfeeds_pro.feedType || 'username',
        status_span = $('#socialfeeds-fetch-status'),
        loader = $('.socialfeeds-wizard-loader-overlay');

        status_span.show().text('Fetching posts...');
        loader.addClass('active');

        $.ajax({
            url: socialfeeds_pro.ajax_url,
            type: 'POST',
            dataType: 'json',
            data: {
                action: 'socialfeeds_pro_instagram_fetch_posts',
                feed_type: feed_type,
                selected_account: selected_account_index,
                limit: 500,
                nonce: socialfeeds_pro.nonce
            },
            success: function (response) {
                loader.removeClass('active');

                if (!response || !response.success) {
                    status_span.text('Failed to load posts').show();
                    return;
                }

                current_account = response.data.account || null;
                if (response.data.posts && response.data.posts.length > 0) {
                    current_posts = response.data.posts;

                    const settings = get_instagram_settings();

                    render_instagram_header_preview(current_account, settings);

                    const sorted_posts = apply_instagram_sort(current_posts);
                    render_preview_grid(sorted_posts, settings);

                    if (current_posts[0]?.media_url) {
                        $('#preview_url_hidden').val(current_posts[0].media_url);
                    }
                    status_span.text('Loaded ' + current_posts.length + ' posts').show();
                } else {
                    $('#socialfeeds-instagram-preview-grid')
                        .html('<div class="socialfeeds-no-preview">No posts found for this account</div>');
                    status_span.text('No posts found').show();
                }
            },
            error: function (xhr) {
                loader.removeClass('active');

                let error_msg = 'Error fetching posts.';
                if (xhr.responseJSON && xhr.responseJSON.data?.message) {
                    error_msg = xhr.responseJSON.data.message;
                }

                $('#socialfeeds-instagram-preview-grid').html('<div class="socialfeeds-no-preview">' + error_msg + '</div>');

                status_span.text(error_msg).show();
            }
        });
    };


    function get_instagram_settings() {
        return {
            instagram_columns_desktop: $('#socialfeeds-instagram-columns-desktop').val() || 3,
            instagram_columns_tablet: $('#socialfeeds-instagram-columns-tablet').val() || 2,
            instagram_columns_mobile: $('#socialfeeds-instagram-columns-mobile').val() || 1,
            instagram_number_posts_desktop: parseInt($('#socialfeeds-instagram-number-posts-desktop').val(), 10) || 12,
            instagram_number_posts_mobile: $('#socialfeeds-instagram-number-posts-mobile').val() || 6,
            instagram_number_posts_tablet: parseInt($('#socialfeeds-instagram-number-posts-tablet').val(), 10) || 8,
            instagram_padding: $('#socialfeeds-instagram-padding').val() || 8,
            instagram_aspect_ratio: $('#socialfeeds-instagram-aspect-ratio').val() || 'square',
            instagram_layout: $('input[name="instagram_layout"]:checked').val() || 'grid',
            instagram_show_feed_posts: $('#socialfeeds-instagram-show-feed-posts').is(':checked'),
            instagram_show_reels: $('#socialfeeds-instagram-show-reels').is(':checked'),
            instagram_play_mode: $('#socialfeeds-instagram-play-mode').val() || 'newtab',
            instagram_header_enabled: $('#socialfeeds-instagram-header-enabled').is(':checked'),
            instagram_likes: $('#socialfeeds-instagram-likes').is(':checked'),
            instagram_comments: $('#socialfeeds-instagram-comments').is(':checked'),
            instagram_caption_enabled: $('#socialfeeds-instagram-caption-enabled').is(':checked'),
            instagram_hover_state: $('#socialfeeds-instagram-hover-state').val() || 'overlay',
            instagram_show_play_icon: $('#socialfeeds-instagram-show-play-icon').is(':checked'),
            instagram_color_scheme: $('#socialfeeds-instagram-color-scheme').val() || 'light',
            instagram_custom_color: $('#socialfeeds-instagram-custom-color').val() || '#000000',
            instagram_header_style: $('#socialfeeds-instagram-header-style').val() || 'left',
            instagram_header_size: $('#socialfeeds-instagram-header-size').val() || 'medium',
            instagram_show_bio_text: $('#socialfeeds-instagram-show-bio-text').is(':checked'),
            instagram_show_followers: $('#socialfeeds-instagram-show-followers').is(':checked'),
            instagram_media_count: $('#socialfeeds-instagram-media-count').is(':checked'),
            instagram_load_more_enabled: $('#socialfeeds-instagram-load-more-enabled').is(':checked'),
            instagram_load_more_count: parseInt($('#socialfeeds-instagram-load-more-count').val(), 10) || 12,
            instagram_load_more_text: $('#socialfeeds-instagram-load-more-text').val() || 'Load More',
            instagram_load_more_bg_color: $('#socialfeeds-instagram-load-more-bg-color').val(),
            instagram_load_more_hover_color: $('#socialfeeds-instagram-load-more-hover-color').val(),
            instagram_load_more_text_color: $('#socialfeeds-instagram-load-more-text-color').val(),
            instagram_follow_button_enabled: $('#socialfeeds-instagram-follow-button-enabled').is(':checked'),
            instagram_follow_button_text: $('#socialfeeds-instagram-follow-button-text').val() || 'Follow on Instagram',
            instagram_follow_button_bg_color: $('#socialfeeds-instagram-follow-button-bg-color').val(),
            instagram_follow_button_text_color: $('#socialfeeds-instagram-follow-button-text-color').val(),
            instagram_follow_button_hover_color: $('#socialfeeds-instagram-follow-button-hover-color').val(),
            instagram_custom_avatar: $('#socialfeeds-custom-avatar-url').val()
        };
    }

    $('input[name="instagram_selected_account"]').on('change', function () {
        fetch_and_update_preview();
    });

    $(document).on('change input', '.socialfeeds-sidebar-content input, .socialfeeds-sidebar-content select', function () {
        let $target = $(this),
        name = $target.attr('name');

        // Update display values for range sliders
        if ($target.attr('type') === 'range') {
            $target.closest('.socialfeeds-control-group').find('.socialfeeds-value-display').text($target.val() + (name.includes('padding') ? 'px' : ' Columns'));
        }

        // Show/Hide custom color group
        if (name === 'instagram_color_scheme') {
            if ($target.val() === 'custom') {
                $('#socialfeeds-custom-color-group').slideDown();
            } else {
                $('#socialfeeds-custom-color-group').slideUp();
            }
        }

        if (current_posts.length > 0) {
            const settings = get_instagram_settings();

            // Special handling for post limit changes
            if (name && name.startsWith('instagram_number_posts')) {
                let loader = $('.socialfeeds-wizard-loader-overlay');
                loader.addClass('active');

                // Reset visible count to the new limit
                socialfeeds_visible_count = get_responsive_post_limit(settings);

                // Small timeout to allow loader to appear
                setTimeout(() => {
                    const sorted_posts = apply_instagram_sort(current_posts);
                    render_instagram_header_preview(current_account, settings);
                    render_preview_grid(sorted_posts, settings);
                    loader.removeClass('active');
                }, 500);
                return;
            }

            const sorted_posts = apply_instagram_sort(current_posts);
            render_instagram_header_preview(current_account, settings);
            render_preview_grid(sorted_posts, settings);
        }
    });

    // Trigger when sort dropdown changes
    $('#socialfeeds-instagram-sort-by').on('change', function () {
        window.socialfeeds_current_sort = $(this).val();
        if (!current_posts || !current_posts.length) return;
        const settings = get_instagram_settings();
        const sorted_posts = apply_instagram_sort(current_posts);
        render_preview_grid(sorted_posts, settings);
        if (sorted_posts[0]?.media_url) {
            $('#preview_url_hidden').val(sorted_posts[0].media_url);
        }
    });

    // Setup Media Uploader for Custom Avatar
    let custom_avatar_frame;
    $('.socialfeeds-upload-avatar-btn').on('click', function (e) {
        e.preventDefault();
        if (custom_avatar_frame) {
            custom_avatar_frame.open();
            return;
        }
        custom_avatar_frame = wp.media({
            title: 'Select Custom Avatar',
            button: { text: 'Use this image' },
            multiple: false
        });
        custom_avatar_frame.on('select', function () {
            let attachment = custom_avatar_frame.state().get('selection').first().toJSON();
            $('#socialfeeds-custom-avatar-url').val(attachment.url).trigger('change');
            $('.socialfeeds-avatar-preview-wrap').show().find('img').attr('src', attachment.url);
            $('.socialfeeds-remove-avatar-btn').show();
        });
        custom_avatar_frame.open();
    });

    $('.socialfeeds-remove-avatar-btn').on('click', function (e) {
        e.preventDefault();
        $('#socialfeeds-custom-avatar-url').val('').trigger('change');
        $('.socialfeeds-avatar-preview-wrap').hide().find('img').attr('src', '');
        $(this).hide();
    });

    // Connection Modal Select Option
    $('.socialfeeds-ig-select-option').on('click', function (e) {
        e.preventDefault();
        let connection_type = $(this).data('type'),
        admin_page = socialfeeds_pro.admin_page_url;
        if (connection_type === 'manual') {
            window.location.href = admin_page + '&action=create&connection_type=' + connection_type + '&step=token#instagram';
            return;
        }
        window.location.href = admin_page + '&action=create&connection_type=' + connection_type + '#instagram';
    });

    // Check pre-selected account - MOVED INSIDE THE IF BLOCK
    if ($('input[name="instagram_selected_account"]:checked').length) {
        setTimeout(function () {
            if (typeof fetch_and_update_preview === 'function') fetch_and_update_preview();
        }, 500);
    }

    function apply_instagram_sort(posts) {
        if (!posts || !posts.length) return posts;
        let sorted = [...posts];
        switch (window.socialfeeds_current_sort) {
            case 'newest':
                sorted.sort((a, b) => new Date(b.timestamp) - new Date(a.timestamp));
                break;
            case 'likes':
                sorted.sort((a, b) => (b.like_count || 0) - (a.like_count || 0));
                break;
            case 'random':
                for (let i = sorted.length - 1; i > 0; i--) {
                    const j = Math.floor(Math.random() * (i + 1));
                    [sorted[i], sorted[j]] = [sorted[j], sorted[i]];
                }
                break;
        }
        return sorted;
    }


    function render_instagram_header_preview(account, settings) {
        let header_box = $('#socialfeeds-instagram-preview-header');

        if (!settings.instagram_header_enabled || !account) {
            header_box.hide().empty();
            return;
        }

        // Use custom avatar if enabled, otherwise default profile picture
        let avatar_url = settings.instagram_custom_avatar && settings.instagram_custom_avatar.trim() !== '' ? settings.instagram_custom_avatar : account.profile_picture_url;

        let html = `
            <div class="socialfeeds-instagram-header preview ${settings.instagram_header_style || 'standard'} ${settings.instagram_header_size || 'medium'}">
                ${avatar_url ? `
                <div class="preview-avatar">
                    <img src="${avatar_url}" alt="">
                </div>` : ''}

                <div class="preview-meta">
                    <div class="preview-username">
                        ${account.username || ''}
                    </div>
                    ${settings.instagram_show_bio_text && account.biography ? `
                    <div class="preview-bio">
                        ${account.biography}
                    </div>` : ''}
                    ${settings.instagram_show_followers && account.followers_count ? `
                    <div class="preview-followers">
                        <strong>${account.followers_count}</strong> Followers
                    </div>` : ''}
                    ${settings.instagram_media_count && account.media_count ? `
                    <div class="preview-media">
                        <strong>${account.media_count}</strong> Posts
                    </div>` : ''}
                </div>
            </div>
        `;

        header_box.html(html).show();
    }

    // wizard form submission
    $('#socialfeeds-instagram-wizard-form').on('submit', function (e) {
        e.preventDefault();
        let form = $(this);

        // Ensure source input is populated from selected account radio if empty
        let selected_account_val = form.find('input[name="instagram_selected_account"]:checked');
        if (selected_account_val.length && selected_account_val.val()) {
            let source_input = form.find('input[name="source_input"]');
            if (source_input.length) source_input.val(selected_account_val.val());
        }

        let submit_btn = form.find('button[type="submit"]'),
        original_text = submit_btn.text();
        submit_btn.prop('disabled', true).text('Saving...');

        let fd = new FormData(this);
        // Ensure action is correct and nonce is present
        fd.append('action', 'socialfeeds_pro_insta_save_settings');
        fd.append('nonce', socialfeeds_pro.nonce);

        $.ajax({
            url: socialfeeds_pro.ajax_url,
            type: 'POST',
            data: fd,
            processData: false,
            contentType: false,
            //nonce:socialfeeds_pro.nonce,
            dataType: 'json',
            success: function (res) {
                if (res && res.success) {
                    show_toast('Feed saved successfully!');

                    if (res.data && res.data.feed_id) {
                        let feed_id = res.data.feed_id;

                        // Update hidden input so next save updates this feed
                        if (form.find('input[name="edit_id"]').length) {
                            form.find('input[name="edit_id"]').val(feed_id);
                        } else {
                            form.append('<input type="hidden" name="edit_id" value="' + feed_id + '">');
                        }

                        // Update shortcode display
                        let shortcode_text = '[socialfeeds id="' + feed_id + '" platform="instagram"]';
                        $('#socialfeeds-top-shortcode').text(shortcode_text);
                        $('.socialfeeds-copy-shortcode').attr('data-shortcode', shortcode_text);

                        // Update URL without reload
                        let currentUrl = new URL(window.location.href);
                        currentUrl.searchParams.set('edit_id', feed_id);
                        window.history.pushState({ path: currentUrl.href }, '', currentUrl.href);
                    }


                } else {
                    show_toast(res.data?.message || 'Error saving feed', 'error');
                }
            },
            error: function (xhr) {
                show_toast('Network error saving feed', 'error');
            },
            complete: function () {
                submit_btn.prop('disabled', false).text(original_text);
            }
        });
    });

    // Instagram Connection Modal Back/Manual logic
    $('#socialfeeds-ig-manual-btn').on('click', function (e) {
        e.preventDefault();
        $('#socialfeeds-ig-modal-main').fadeOut(200, function () {
            $('#socialfeeds-ig-modal-token').fadeIn(200);
            $('#socialfeeds-ig-token-input').focus();
        });
    });

    $('#socialfeeds-ig-back-btn, #socialfeeds-ig-cancel-btn').on('click', function (e) {
        e.preventDefault();
        $('#socialfeeds-ig-modal-token').fadeOut(200, function () {
            $('#socialfeeds-ig-modal-main').fadeIn(200);
        });
    });

    $(document).on('click', '#socialfeeds-instagram .socialfeeds-preview-device-btn', function (e) {
        e.preventDefault();
        $('#socialfeeds-instagram .socialfeeds-preview-device-btn').removeClass('active');
        $(this).addClass('active');

        let width = $(this).data('width'),
        $preview_wrap = $('#socialfeeds-instagram .socialfeeds-customize-preview');
        if (width === '100%') {
            $preview_wrap.css('width', '').removeClass('socialfeeds-device-mode');
            window.socialfeeds_instagram_device = 'desktop';
        } else {
            $preview_wrap.css('width', width).addClass('socialfeeds-device-mode');
            if (parseInt(width) === 375) {
                window.socialfeeds_instagram_device = 'mobile';
            } else if (parseInt(width) === 768) {
                window.socialfeeds_instagram_device = 'tablet';
            }
        }
        // Sync global device variable
        window.socialfeeds_preview_device = window.socialfeeds_instagram_device;

        $('#socialfeeds-instagram-preview-grid').css(
            'max-width',
            width === '100%' ? '100%' : width + 'px'
        );

        if (current_posts.length) {
            socialfeeds_visible_count = 0; // Reset visible count to force post limit refresh
            render_preview_grid(current_posts, get_instagram_settings());
        }
    });

    // Instagram Wizard Next Step Handler
    $('#socialfeeds-ig-next-btn').on('click', function (e) {
        e.preventDefault();
        let selected_account = $('input[name="instagram_selected_account"]:checked').val();

        if (!selected_account) {
            alert('Please select an Instagram account to proceed.');
            return;
        }

        // Update the hidden source field so it saves correctly
        $('#socialfeeds-source-input-field').val(selected_account);

        // Switch to the Customize tab
        $('#socialfeeds-instagram-tab-customize').trigger('click');

        // Ensure scroll to top
        window.scrollTo({ top: 0, behavior: 'smooth' });
    });

    // Instagram Tab Switching Logic
    $('#socialfeeds-instagram-wizard-form .socialfeeds-wizard-tab').on('click', function (e) {
        e.preventDefault();
        e.stopPropagation(); // Stop bubbling to prevent Core JS from catching this

        let tab_name = $(this).data('tab');

        // Update Tabs styling
        $('#socialfeeds-instagram-wizard-form .socialfeeds-wizard-tab').removeClass('active');
        $(this).addClass('active');

        // Update Content visibility
        $('#socialfeeds-instagram-wizard-form .socialfeeds-wizard-tab-content').removeClass('active').hide();

        let $target_content = $('#socialfeeds-instagram-content-' + tab_name);
        if ($target_content.length) {
            $target_content.addClass('active').show().attr('style', 'display: block !important;');
        }

        // Specific actions
        if (tab_name === 'customize') {
            if (typeof fetch_and_update_preview === 'function') {
                fetch_and_update_preview();
            }
        }
    });

    $('#socialfeeds-ig-add-new-modal-trigger').on('click', function (e) {
        e.preventDefault();
        $('#socialfeeds-ig-connection-modal').fadeIn().css('display', 'flex');
    });

    $('#socialfeeds-edit-source-btn').on('click', function (e) {
        e.preventDefault();
        // Return to source tab
        $('#socialfeeds-instagram-tab-source').trigger('click');
    });

    // Note: Use delegating for modal close since it might be dynamic or shared
    $(document).on('click', '.socialfeeds-modal-close[data-modal="socialfeeds-ig-connection-modal"], #socialfeeds-ig-connection-modal', function (e) {
        if (e.target !== this && !$(e.target).hasClass('socialfeeds-modal-close')) return;
        $('#socialfeeds-ig-connection-modal').fadeOut();
    });


    $('#socialfeeds-ig-modal-token-form').on('submit', function (e) {
        e.preventDefault();
        let token = $('#socialfeeds-modal-ig-token').val(),
        submit_btn = $(this).find('button[type="submit"]'),
        original_text = submit_btn.text();

        if (!token) {
            show_toast('Please enter an access token', 'error');
            return;
        }

        submit_btn.prop('disabled', true).text('Saving...');

        $.ajax({
            url: socialfeeds_pro.ajax_url,
            type: 'POST',
            data: {
                action: 'socialfeeds_pro_validate_instagram_token',
                access_token: token,
                nonce: socialfeeds_pro.nonce
            },
            dataType: 'json',
            success: function (response) {
                if (response.success) {
                    show_toast('Instagram settings saved successfully!');
                    setTimeout(function () {
                        $('#socialfeeds-ig-connection-modal').fadeOut(200, function () {
                            $(this).removeClass('active');
                            location.reload();
                        });
                    }, 1000);
                } else {
                    show_toast(response.data.message || 'Error saving settings', 'error');
                }
            },
            error: function () {
                show_toast('Error connecting to server', 'error');
            },
            complete: function () {
                submit_btn.prop('disabled', false).text(original_text);
            }
        });
    });

    $('#socialfeeds-back-btn').on('click', function (e) {
        e.preventDefault();
        window.location.href = 'admin.php?page=socialfeeds&action=create#instagram';
    });

    function re_initialize_instagram_form_handlers() {
        let url_params = new URLSearchParams(window.location.search),
        action = url_params.get('action'),
        hash = window.location.hash,
        edit_id_param = url_params.get('edit_id');

        // If we're creating a new Instagram feed
        if (action === 'create' && hash === '#instagram') {

            let new_id;
            if (edit_id_param) {
                new_id = edit_id_param;
            }

            // Add hidden edit_id field if it doesn't exist
            if ($('#socialfeeds-instagram-wizard-form input[name="edit_id"]').length === 0) {
                $('#socialfeeds-instagram-wizard-form').append('<input type="hidden" name="edit_id" value="' + new_id + '">');
            } else {
                $('#socialfeeds-instagram-wizard-form input[name="edit_id"]').val(new_id);
            }

            // Update top shortcode display
            $('#socialfeeds-top-shortcode').text('[socialfeeds id="' + new_id + '" platform="instagram"]');
            $('.socialfeeds-copy-shortcode').attr('data-shortcode', '[socialfeeds id="' + new_id + '" platform="instagram"]');
        }
    }

    // Call on load
    re_initialize_instagram_form_handlers();

    // Re-call when hash changes (since main plugin uses hash navigation)
    $(window).on('hashchange', function () {
        re_initialize_instagram_form_handlers();
    });

    // Instagram Fullscreen Handler
    $('#socialfeeds-instagram-content-customize .socialfeeds-fullscreen-btn').on('click', function (e) {
        // Only trigger if we are inside Instagram customize tab
        let $instacontainer = $(this).closest('#socialfeeds-instagram-content-customize');

        if ($instacontainer.length) {
            e.preventDefault();
            let $icon = $(this).find('.socialfeed-fullscreen');

            $instacontainer.toggleClass('socialfeeds-fullscreen');
            $('body').toggleClass('socialfeeds-body-lock');

            if ($instacontainer.hasClass('socialfeeds-fullscreen')) {
                $icon.removeClass('dashicons-fullscreen-alt').addClass('dashicons-fullscreen-exit-alt');
                if (typeof show_toast === 'function') show_toast('Fullscreen mode enabled');
            } else {
                $icon.removeClass('dashicons-fullscreen-exit-alt').addClass('dashicons-fullscreen-alt');
                if (typeof show_toast === 'function') show_toast('Fullscreen mode disabled');
            }
        }
    });

    // Instagram Item Click Handler
    $(document).on('click', '#socialfeeds-instagram-preview-grid .socialfeeds-preview-item', function (e) {
        // Prevent default if it's a link, though we usually handle it
        e.preventDefault();

        let $item = $(this),
        settings = get_instagram_settings(),
        mode = settings.instagram_play_mode || 'newtab',
        permalink = $item.attr('data-permalink'),
        media_url = $item.attr('data-media-url'),
        media_type = $item.attr('data-media-type');

        if (mode === 'newtab') {
            if (permalink) {
                window.open(permalink, '_blank');
            } else {
                show_toast('No permalink available', 'error');
            }
        } else if (mode === 'lightbox') {
            if (!media_url) {
                show_toast('No media URL available', 'error');
                return;
            }

            // High-end Lightbox Overlay
            let media_content = '';
            if (media_type === 'VIDEO') {
                media_content = `
                    <video src="${media_url}" controls autoplay 
                        style="max-width: 90vw; max-height: 80vh; border-radius: 12px; box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.5); border: 2px solid rgba(255,255,255,0.1);">
                        Your browser does not support the video tag.
                    </video>`;
            } else {
                media_content = `
                    <img src="${media_url}" 
                        style="max-width: 90vw; max-height: 80vh; border-radius: 12px; box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.5); object-fit: contain; border: 2px solid rgba(255,255,255,0.1);">`;
            }

            let $lightbox = $(`
                <div class="socialfeeds-premium-lightbox" style="position: fixed; inset: 0; z-index: 999999; display: flex; align-items: center; justify-content: center; backdrop-filter: blur(8px); background: rgba(0, 0, 0, 0.85); opacity: 0; transition: opacity 0.3s ease;">
                    <button class="close-btn" style="position: absolute; top: 30px; right: 30px; width: 44px; height: 44px; background: rgba(255,255,255,0.1); border: none; border-radius: 50%; color: white; font-size: 24px; cursor: pointer; display: flex; align-items: center; justify-content: center; transition: all 0.2s;">&times;</button>
                    <div class="lightbox-content-wrap" style="transform: scale(0.9); transition: transform 0.3s cubic-bezier(0.34, 1.56, 0.64, 1);">
                        ${media_content}
                        ${permalink ? `<div style="text-align: center; margin-top: 15px;"><a href="${permalink}" target="_blank" style="color: white; text-decoration: none; background: rgba(255,255,255,0.1); padding: 8px 16px; border-radius: 20px; font-size: 13px; font-weight: 500;">View on Instagram</a></div>` : ''}
                    </div>
                </div>
            `);

            $('body').append($lightbox);

            // Animate In
            setTimeout(() => {
                $lightbox.css('opacity', '1');
                $lightbox.find('.lightbox-content-wrap').css('transform', 'scale(1)');
            }, 10);

            let close_lightbox = () => {
                $lightbox.css('opacity', '0');
                $lightbox.find('.lightbox-content-wrap').css('transform', 'scale(0.9)');
                setTimeout(() => $lightbox.remove(), 300);
            };

            $lightbox.on('click', function (evt) {
                if (evt.target === this || $(evt.target).hasClass('close-btn')) {
                    close_lightbox();
                }
            });

            $(document).on('keydown.sf_lightbox', function (evt) {
                if (evt.key === 'Escape') {
                    close_lightbox();
                    $(document).off('keydown.sf_lightbox');
                }
            });

        } else if (mode === 'inline') {
            if (media_type !== 'VIDEO') {
                // If it's an image, maybe fallback to newtab?
                if (permalink) window.open(permalink, '_blank');
                return;
            }

            let $media_box = $item.find('.socialfeeds-preview-media');
            if ($media_box.find('video').length) return; // Already playing

            // Show Loading state if needed?
            $media_box.html(`
                <video src="${media_url}" controls autoplay playsinline
                    style="width: 100%; height: 100%; object-fit: cover; border-radius: inherit;">
                </video>
            `);
        }
    });

    $('#socialfeeds-add-new-feed').on('click', function (e) {
        e.preventDefault();
        let $modal = $('#socialfeeds-ig-connection-modal');
        if ($modal.hasClass('active')) {
            $modal.removeClass('active').fadeOut(300, function () {
                window.location.href = 'admin.php?page=socialfeeds#instagram';
            });
        } else {
            window.location.href = 'admin.php?page=socialfeeds#instagram';
        }
    });

    // Instagram Preview Load More Handler
    $(document).on('click', '#socialfeeds-load-more-btn', function (e) {
        e.preventDefault();
        let $btn = $(this),
        original_text = $btn.text();

        $btn.text('Loading...').addClass('socialfeeds-loading').prop('disabled', true);

        setTimeout(() => {
            let settings = get_instagram_settings(),
            load_count = parseInt($btn.attr('data-load-count')) || 12;

            socialfeeds_visible_count += load_count;

            let sorted_posts = apply_instagram_sort(current_posts);
            render_preview_grid(sorted_posts, settings);

        }, 500);
    });

});